/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.factory;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class ExternalMetaDataFactory {
    public static ShardingSphereDatabase create(String databaseName, DatabaseConfiguration databaseConfig, ConfigurationProperties props, ComputeNodeInstanceContext computeNodeInstanceContext) throws SQLException {
        return ShardingSphereDatabase.create((String)databaseName, (DatabaseType)DatabaseTypeEngine.getProtocolType((DatabaseConfiguration)databaseConfig, (ConfigurationProperties)props), (DatabaseConfiguration)databaseConfig, (ConfigurationProperties)props, (ComputeNodeInstanceContext)computeNodeInstanceContext);
    }

    public static Map<String, ShardingSphereDatabase> create(Map<String, DatabaseConfiguration> databaseConfigMap, ConfigurationProperties props, ComputeNodeInstanceContext computeNodeInstanceContext) throws SQLException {
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType(databaseConfigMap, (ConfigurationProperties)props);
        SystemDatabase systemDatabase = new SystemDatabase(protocolType);
        ConcurrentHashMap<String, ShardingSphereDatabase> result = new ConcurrentHashMap<String, ShardingSphereDatabase>(databaseConfigMap.size() + systemDatabase.getSystemDatabaseSchemaMap().size(), 1.0f);
        result.putAll(ExternalMetaDataFactory.createGenericDatabases(databaseConfigMap, protocolType, systemDatabase, props, computeNodeInstanceContext));
        result.putAll(ExternalMetaDataFactory.createSystemDatabases(databaseConfigMap, protocolType, systemDatabase, props));
        return result;
    }

    private static Map<String, ShardingSphereDatabase> createGenericDatabases(Map<String, DatabaseConfiguration> databaseConfigMap, DatabaseType protocolType, SystemDatabase systemDatabase, ConfigurationProperties props, ComputeNodeInstanceContext computeNodeInstanceContext) throws SQLException {
        HashMap<String, ShardingSphereDatabase> result = new HashMap<String, ShardingSphereDatabase>(databaseConfigMap.size(), 1.0f);
        for (Map.Entry<String, DatabaseConfiguration> entry : databaseConfigMap.entrySet()) {
            String databaseName = entry.getKey();
            if (entry.getValue().getStorageUnits().isEmpty() && systemDatabase.getSystemSchemas().contains(databaseName)) continue;
            result.put(databaseName.toLowerCase(), ShardingSphereDatabase.create((String)databaseName, (DatabaseType)protocolType, (DatabaseConfiguration)entry.getValue(), (ConfigurationProperties)props, (ComputeNodeInstanceContext)computeNodeInstanceContext));
        }
        return result;
    }

    private static Map<String, ShardingSphereDatabase> createSystemDatabases(Map<String, DatabaseConfiguration> databaseConfigMap, DatabaseType protocolType, SystemDatabase systemDatabase, ConfigurationProperties props) {
        HashMap<String, ShardingSphereDatabase> result = new HashMap<String, ShardingSphereDatabase>(systemDatabase.getSystemDatabaseSchemaMap().size(), 1.0f);
        for (String each : systemDatabase.getSystemDatabaseSchemaMap().keySet()) {
            if (databaseConfigMap.containsKey(each) && !databaseConfigMap.get(each).getStorageUnits().isEmpty()) continue;
            result.put(each.toLowerCase(), ShardingSphereDatabase.create((String)each, (DatabaseType)protocolType, (ConfigurationProperties)props));
        }
        return result;
    }

    @Generated
    private ExternalMetaDataFactory() {
    }
}

