/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.metadata.table;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereView;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlViewSwapper;
import org.apache.shardingsphere.mode.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.node.path.metadata.ViewMetaDataNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class ViewMetaDataPersistService {
    private final PersistRepository repository;
    private final MetaDataVersionPersistService metaDataVersionPersistService;

    public Collection<ShardingSphereView> load(String databaseName, String schemaName) {
        return this.repository.getChildrenKeys(ViewMetaDataNodePath.getMetaDataViewsPath((String)databaseName, (String)schemaName)).stream().map(each -> this.load(databaseName, schemaName, (String)each)).collect(Collectors.toList());
    }

    public ShardingSphereView load(String databaseName, String schemaName, String viewName) {
        String view = this.repository.query(ViewMetaDataNodePath.getViewVersionPath((String)databaseName, (String)schemaName, (String)viewName, (String)this.repository.query(ViewMetaDataNodePath.getViewActiveVersionPath((String)databaseName, (String)schemaName, (String)viewName))));
        return new YamlViewSwapper().swapToObject((YamlShardingSphereView)YamlEngine.unmarshal((String)view, YamlShardingSphereView.class));
    }

    public void persist(String databaseName, String schemaName, Collection<ShardingSphereView> views) {
        LinkedList<MetaDataVersion> metaDataVersions = new LinkedList<MetaDataVersion>();
        for (ShardingSphereView each : views) {
            String viewName = each.getName().toLowerCase();
            List<String> versions = this.metaDataVersionPersistService.getVersions(ViewMetaDataNodePath.getViewVersionsPath((String)databaseName, (String)schemaName, (String)viewName));
            String nextActiveVersion = versions.isEmpty() ? "0" : String.valueOf(Integer.parseInt(versions.get(0)) + 1);
            this.repository.persist(ViewMetaDataNodePath.getViewVersionPath((String)databaseName, (String)schemaName, (String)viewName, (String)nextActiveVersion), YamlEngine.marshal((Object)new YamlViewSwapper().swapToYamlConfiguration(each)));
            if (Strings.isNullOrEmpty((String)this.getActiveVersion(databaseName, schemaName, viewName))) {
                this.repository.persist(ViewMetaDataNodePath.getViewActiveVersionPath((String)databaseName, (String)schemaName, (String)viewName), "0");
            }
            metaDataVersions.add(new MetaDataVersion(ViewMetaDataNodePath.getViewPath((String)databaseName, (String)schemaName, (String)viewName), this.getActiveVersion(databaseName, schemaName, viewName), nextActiveVersion));
        }
        this.metaDataVersionPersistService.switchActiveVersion(metaDataVersions);
    }

    private String getActiveVersion(String databaseName, String schemaName, String viewName) {
        return this.repository.query(ViewMetaDataNodePath.getViewActiveVersionPath((String)databaseName, (String)schemaName, (String)viewName));
    }

    public void delete(String databaseName, String schemaName, String viewName) {
        this.repository.delete(ViewMetaDataNodePath.getViewPath((String)databaseName, (String)schemaName, (String)viewName.toLowerCase()));
    }

    @Generated
    public ViewMetaDataPersistService(PersistRepository repository, MetaDataVersionPersistService metaDataVersionPersistService) {
        this.repository = repository;
        this.metaDataVersionPersistService = metaDataVersionPersistService;
    }
}

