/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.type.schema;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.metadata.refresher.MetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.divided.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class DropSchemaStatementSchemaRefresher
implements MetaDataRefresher<DropSchemaStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DatabaseType databaseType, DropSchemaStatement sqlStatement, ConfigurationProperties props) {
        metaDataManagerPersistService.dropSchema(database.getName(), this.getSchemaNames(sqlStatement));
    }

    private Collection<String> getSchemaNames(DropSchemaStatement sqlStatement) {
        LinkedList<String> result = new LinkedList<String>();
        for (IdentifierValue each : sqlStatement.getSchemaNames()) {
            result.add(each.getValue().toLowerCase());
        }
        return result;
    }

    @Override
    public Class<DropSchemaStatement> getType() {
        return DropSchemaStatement.class;
    }
}

