/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import lombok.Generated;

public enum KernelSupportedSystemTables {
    MYSQL_SYS("MySQL", "sys", new HashSet<String>(Collections.singleton("sys_config"))),
    MYSQL_SHARDING_SPHERE("MySQL", "shardingsphere", new HashSet<String>(Arrays.asList("sharding_table_statistics", "cluster_information"))),
    POSTGRESQL_INFORMATION_SCHEMA("PostgreSQL", "information_schema", new HashSet<String>(Arrays.asList("columns", "tables", "views"))),
    POSTGRESQL_PG_CATALOG("PostgreSQL", "pg_catalog", new HashSet<String>(Arrays.asList("pg_aggregate", "pg_class", "pg_database", "pg_tables", "pg_inherits", "pg_tablespace", "pg_trigger", "pg_namespace", "pg_roles"))),
    POSTGRESQL_SHARDING_SPHERE("PostgreSQL", "shardingsphere", new HashSet<String>(Arrays.asList("sharding_table_statistics", "cluster_information"))),
    OPEN_GAUSS_INFORMATION_SCHEMA("openGauss", "information_schema", Collections.emptySet()),
    OPEN_GAUSS_PG_CATALOG("openGauss", "pg_catalog", new HashSet<String>(Arrays.asList("pg_class", "pg_namespace", "pg_database", "pg_roles", "pg_tables", "pg_tablespace"))),
    OPEN_GAUSS_BLOCKCHAIN("openGauss", "blockchain", Collections.emptySet()),
    OPEN_GAUSS_CSTORE("openGauss", "cstore", Collections.emptySet()),
    OPEN_GAUSS_DB4AI("openGauss", "db4ai", Collections.emptySet()),
    OPEN_GAUSS_DBE_PERF("openGauss", "dbe_perf", Collections.emptySet()),
    OPEN_GAUSS_DBE_PLDEBUGGER("openGauss", "dbe_pldebugger", Collections.emptySet()),
    OPEN_GAUSS_GAUSSDB("openGauss", "gaussdb", Collections.emptySet()),
    OPEN_GAUSS_ORACLE("openGauss", "oracle", Collections.emptySet()),
    OPEN_GAUSS_PKG_SERVICE("openGauss", "pkg_service", Collections.emptySet()),
    OPEN_GAUSS_SNAPSHOT("openGauss", "snapshot", Collections.emptySet()),
    OPEN_GAUSS_PLDEVELOPER("openGauss", "dbe_pldeveloper", Collections.emptySet()),
    OPEN_GAUSS_PG_TOAST("openGauss", "pg_toast", Collections.emptySet()),
    OPEN_GAUSS_PKG_UTIL("openGauss", "pkg_util", Collections.emptySet()),
    OPEN_GAUSS_SQLADVISOR("openGauss", "sqladvisor", Collections.emptySet()),
    OPEN_GAUSS_SHARDING_SPHERE("openGauss", "shardingsphere", new HashSet<String>(Arrays.asList("sharding_table_statistics", "cluster_information")));

    private static final Map<String, KernelSupportedSystemTables> SCHEMA_NAME_TO_TABLES;
    private final String databaseType;
    private final String schema;
    private final Collection<String> tables;

    public static boolean isSupportedSystemTable(String schema, String tableName) {
        for (KernelSupportedSystemTables each : KernelSupportedSystemTables.values()) {
            if (!each.getSchema().equals(schema) || !each.getTables().contains(tableName)) continue;
            return true;
        }
        return false;
    }

    @Generated
    private KernelSupportedSystemTables(String databaseType, String schema, Collection<String> tables) {
        this.databaseType = databaseType;
        this.schema = schema;
        this.tables = tables;
    }

    @Generated
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public Collection<String> getTables() {
        return this.tables;
    }

    static {
        SCHEMA_NAME_TO_TABLES = new HashMap<String, KernelSupportedSystemTables>(KernelSupportedSystemTables.values().length, 1.0f);
        for (KernelSupportedSystemTables each : KernelSupportedSystemTables.values()) {
            SCHEMA_NAME_TO_TABLES.put(each.getDatabaseType() + "." + each.getSchema(), each);
        }
    }
}

