/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.algorithm.cover;

import com.google.common.base.Strings;
import java.util.Properties;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.mask.algorithm.MaskAlgorithmPropertiesChecker;
import org.apache.shardingsphere.mask.spi.MaskAlgorithm;

public final class MaskFromXToYMaskAlgorithm
implements MaskAlgorithm<Object, String> {
    private static final String FROM_X = "from-x";
    private static final String TO_Y = "to-y";
    private static final String REPLACE_CHAR = "replace-char";
    private Integer fromX;
    private Integer toY;
    private Character replaceChar;

    public void init(Properties props) {
        this.fromX = this.createFromX(props);
        this.toY = this.createToY(props);
        this.replaceChar = this.createReplaceChar(props);
        ShardingSpherePreconditions.checkState((this.fromX <= this.toY ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "fromX must be less than or equal to toY", new Object[0]));
    }

    private Integer createFromX(Properties props) {
        MaskAlgorithmPropertiesChecker.checkPositiveInteger(props, FROM_X, this);
        return Integer.parseInt(props.getProperty(FROM_X));
    }

    private Integer createToY(Properties props) {
        MaskAlgorithmPropertiesChecker.checkPositiveInteger(props, TO_Y, this);
        return Integer.parseInt(props.getProperty(TO_Y));
    }

    private Character createReplaceChar(Properties props) {
        MaskAlgorithmPropertiesChecker.checkSingleChar(props, REPLACE_CHAR, this);
        return Character.valueOf(props.getProperty(REPLACE_CHAR).charAt(0));
    }

    public String mask(Object plainValue) {
        String result;
        String string = result = null == plainValue ? null : String.valueOf(plainValue);
        if (Strings.isNullOrEmpty((String)result)) {
            return result;
        }
        if (result.length() <= this.fromX) {
            return result;
        }
        char[] chars = result.toCharArray();
        int minLength = Math.min(this.toY, chars.length - 1);
        for (int i = this.fromX.intValue(); i <= minLength; ++i) {
            chars[i] = this.replaceChar.charValue();
        }
        return new String(chars);
    }

    public String getType() {
        return "MASK_FROM_X_TO_Y";
    }
}

