/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal.show;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Calendar;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;

public final class EncryptShowColumnsMergedResult
implements MergedResult {
    private static final int COLUMN_FIELD_INDEX = 1;
    private final String tableName;
    private final MergedResult mergedResult;
    private final EncryptRule rule;

    public EncryptShowColumnsMergedResult(MergedResult mergedResult, SQLStatementContext sqlStatementContext, EncryptRule rule) {
        ShardingSpherePreconditions.checkState((sqlStatementContext instanceof TableAvailable && 1 == ((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().size() ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("SHOW COLUMNS FOR MULTI TABLES"));
        this.tableName = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().iterator().next()).getTableName().getIdentifier().getValue();
        this.mergedResult = mergedResult;
        this.rule = rule;
    }

    public boolean next() throws SQLException {
        boolean hasNext = this.mergedResult.next();
        Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(this.tableName);
        if (hasNext && !encryptTable.isPresent()) {
            return true;
        }
        if (!hasNext) {
            return false;
        }
        String columnName = this.mergedResult.getValue(1, String.class).toString();
        while (this.isDerivedColumn(encryptTable.get(), columnName)) {
            hasNext = this.mergedResult.next();
            if (!hasNext) {
                return false;
            }
            columnName = this.mergedResult.getValue(1, String.class).toString();
        }
        return true;
    }

    private boolean isDerivedColumn(EncryptTable encryptTable, String columnName) {
        return encryptTable.isAssistedQueryColumn(columnName) || encryptTable.isLikeQueryColumn(columnName);
    }

    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (1 == columnIndex) {
            String columnName = this.mergedResult.getValue(1, type).toString();
            Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(this.tableName);
            if (!encryptTable.isPresent()) {
                return columnName;
            }
            Optional<String> logicColumn = encryptTable.get().isCipherColumn(columnName) ? Optional.of(encryptTable.get().getLogicColumnByCipherColumn(columnName)) : Optional.empty();
            return logicColumn.orElse(columnName);
        }
        return this.mergedResult.getValue(columnIndex, type);
    }

    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    public boolean wasNull() throws SQLException {
        return this.mergedResult.wasNull();
    }
}

