/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authentication;

import java.util.Arrays;
import lombok.Generated;
import org.apache.shardingsphere.authentication.Authenticator;
import org.apache.shardingsphere.authentication.AuthenticatorType;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;

public final class AuthenticatorFactory<E extends Enum<E>> {
    private final Class<E> authenticatorTypeClass;
    private final AuthorityRule rule;

    public Authenticator newInstance(ShardingSphereUser user) {
        E authenticatorType = this.getAuthenticatorType(this.rule.getAuthenticatorType(user));
        return ((AuthenticatorType)authenticatorType).getAuthenticatorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private E getAuthenticatorType(String authenticationMethodName) {
        try {
            return Enum.valueOf(this.authenticatorTypeClass, authenticationMethodName.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            return (E)Arrays.stream((Enum[])this.authenticatorTypeClass.getEnumConstants()).filter(rec$ -> ((AuthenticatorType)rec$).isDefault()).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }

    @Generated
    public AuthenticatorFactory(Class<E> authenticatorTypeClass, AuthorityRule rule) {
        this.authenticatorTypeClass = authenticatorTypeClass;
        this.rule = rule;
    }
}

