/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.api.yaml;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.api.ShardingSphereDataSourceFactory;
import org.apache.shardingsphere.driver.yaml.YamlJDBCConfiguration;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.mode.YamlModeConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;

public final class YamlShardingSphereDataSourceFactory {
    public static DataSource createDataSource(File yamlFile) throws SQLException, IOException {
        YamlJDBCConfiguration rootConfig = (YamlJDBCConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlJDBCConfiguration.class);
        return YamlShardingSphereDataSourceFactory.createDataSource((Map<String, DataSource>)new YamlDataSourceConfigurationSwapper().swapToDataSources(rootConfig.getDataSources()), rootConfig);
    }

    public static DataSource createDataSource(byte[] yamlBytes) throws SQLException, IOException {
        YamlJDBCConfiguration rootConfig = (YamlJDBCConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlJDBCConfiguration.class);
        return YamlShardingSphereDataSourceFactory.createDataSource((Map<String, DataSource>)new YamlDataSourceConfigurationSwapper().swapToDataSources(rootConfig.getDataSources()), rootConfig);
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, File yamlFile) throws SQLException, IOException {
        return YamlShardingSphereDataSourceFactory.createDataSource(dataSourceMap, (YamlJDBCConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlJDBCConfiguration.class));
    }

    public static DataSource createDataSource(DataSource dataSource, File yamlFile) throws SQLException, IOException {
        return YamlShardingSphereDataSourceFactory.createDataSource(dataSource, (YamlJDBCConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlJDBCConfiguration.class));
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, byte[] yamlBytes) throws SQLException, IOException {
        return YamlShardingSphereDataSourceFactory.createDataSource(dataSourceMap, (YamlJDBCConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlJDBCConfiguration.class));
    }

    public static DataSource createDataSource(DataSource dataSource, byte[] yamlBytes) throws SQLException, IOException {
        return YamlShardingSphereDataSourceFactory.createDataSource(dataSource, (YamlJDBCConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlJDBCConfiguration.class));
    }

    private static DataSource createDataSource(DataSource dataSource, YamlJDBCConfiguration jdbcConfig) throws SQLException {
        LinkedHashMap<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>(Collections.singletonMap(Strings.isNullOrEmpty((String)jdbcConfig.getDatabaseName()) ? "logic_db" : jdbcConfig.getDatabaseName(), dataSource));
        return YamlShardingSphereDataSourceFactory.createDataSource(dataSourceMap, jdbcConfig);
    }

    private static DataSource createDataSource(Map<String, DataSource> dataSourceMap, YamlJDBCConfiguration jdbcConfig) throws SQLException {
        ModeConfiguration modeConfig = null == jdbcConfig.getMode() ? null : new YamlModeConfigurationSwapper().swapToObject(jdbcConfig.getMode());
        jdbcConfig.rebuild();
        Collection ruleConfigs = new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(jdbcConfig.getRules());
        return ShardingSphereDataSourceFactory.createDataSource(jdbcConfig.getDatabaseName(), modeConfig, dataSourceMap, (Collection<RuleConfiguration>)ruleConfigs, jdbcConfig.getProps());
    }

    @Generated
    private YamlShardingSphereDataSourceFactory() {
    }
}

