/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.rule;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.sqlfederation.config.SQLFederationRuleConfiguration;
import org.apache.shardingsphere.sqlfederation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.sqlfederation.optimizer.context.OptimizerContextFactory;

public final class SQLFederationRule
implements GlobalRule {
    private final SQLFederationRuleConfiguration configuration;
    private final AtomicReference<OptimizerContext> optimizerContext;

    public SQLFederationRule(SQLFederationRuleConfiguration ruleConfig, Collection<ShardingSphereDatabase> databases) {
        this.configuration = ruleConfig;
        this.optimizerContext = new AtomicReference<OptimizerContext>(OptimizerContextFactory.create(databases));
    }

    public void refresh(Collection<ShardingSphereDatabase> databases, GlobalRule.GlobalRuleChangedType changedType) {
        this.optimizerContext.set(OptimizerContextFactory.create(databases));
    }

    public OptimizerContext getOptimizerContext() {
        return this.optimizerContext.get();
    }

    public int getOrder() {
        return 1000;
    }

    @Generated
    public SQLFederationRuleConfiguration getConfiguration() {
        return this.configuration;
    }
}

