/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.algorithm.keygen.snowflake;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.context.AlgorithmSQLContext;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmExecuteException;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.algorithm.keygen.core.KeyGenerateAlgorithm;
import org.apache.shardingsphere.infra.algorithm.keygen.snowflake.TimeService;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContextAware;

public final class SnowflakeKeyGenerateAlgorithm
implements KeyGenerateAlgorithm,
ComputeNodeInstanceContextAware {
    public static final long EPOCH;
    private static final String MAX_VIBRATION_OFFSET_KEY = "max-vibration-offset";
    private static final String MAX_TOLERATE_TIME_DIFFERENCE_MILLIS_KEY = "max-tolerate-time-difference-milliseconds";
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_BITS = 10L;
    private static final long SEQUENCE_MASK = 4095L;
    private static final long WORKER_ID_LEFT_SHIFT_BITS = 12L;
    private static final long TIMESTAMP_LEFT_SHIFT_BITS = 22L;
    private static final int DEFAULT_VIBRATION_VALUE = 1;
    private static final int MAX_TOLERATE_TIME_DIFFERENCE_MILLIS = 10;
    private static final int DEFAULT_WORKER_ID = 0;
    private static TimeService timeService;
    private final AtomicReference<ComputeNodeInstanceContext> computeNodeInstanceContext = new AtomicReference();
    private final AtomicInteger sequenceOffset = new AtomicInteger(-1);
    private final AtomicLong sequence = new AtomicLong();
    private final AtomicLong lastMillis = new AtomicLong();
    private Properties props;
    private int maxVibrationOffset;
    private int maxTolerateTimeDifferenceMillis;

    public void init(Properties props) {
        this.props = props;
        this.maxVibrationOffset = this.getMaxVibrationOffset(props);
        this.maxTolerateTimeDifferenceMillis = this.getMaxTolerateTimeDifferenceMillis(props);
    }

    private int getMaxVibrationOffset(Properties props) {
        int result = Integer.parseInt(props.getOrDefault((Object)MAX_VIBRATION_OFFSET_KEY, (Object)1).toString());
        ShardingSpherePreconditions.checkState((result >= 0 && (long)result <= 4095L ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Illegal max vibration offset.", new Object[0]));
        return result;
    }

    private int getMaxTolerateTimeDifferenceMillis(Properties props) {
        int result = Integer.parseInt(props.getOrDefault((Object)MAX_TOLERATE_TIME_DIFFERENCE_MILLIS_KEY, (Object)10).toString());
        ShardingSpherePreconditions.checkState((result >= 0 ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Illegal max tolerate time difference milliseconds.", new Object[0]));
        return result;
    }

    public void setComputeNodeInstanceContext(ComputeNodeInstanceContext computeNodeInstanceContext) {
        this.computeNodeInstanceContext.set(computeNodeInstanceContext);
        if (null != computeNodeInstanceContext) {
            computeNodeInstanceContext.generateWorkerId(this.props);
        }
    }

    public Collection<Long> generateKeys(AlgorithmSQLContext context, int keyGenerateCount) {
        LinkedList<Long> result = new LinkedList<Long>();
        for (int index = 0; index < keyGenerateCount; ++index) {
            result.add(this.generateKey());
        }
        return result;
    }

    private synchronized Long generateKey() {
        long currentMillis = timeService.getCurrentMillis();
        if (this.waitTolerateTimeDifferenceIfNeed(currentMillis)) {
            currentMillis = timeService.getCurrentMillis();
        }
        if (this.lastMillis.get() == currentMillis) {
            this.sequence.set(this.sequence.incrementAndGet() & 0xFFFL);
            if (0L == this.sequence.get()) {
                currentMillis = this.waitUntilNextTime(currentMillis);
            }
        } else {
            this.vibrateSequenceOffset();
            this.sequence.set(this.sequenceOffset.get());
        }
        this.lastMillis.set(currentMillis);
        return currentMillis - EPOCH << 22 | (long)this.getWorkerId() << 12 | this.sequence.get();
    }

    private boolean waitTolerateTimeDifferenceIfNeed(long currentMillis) {
        if (this.lastMillis.get() <= currentMillis) {
            return false;
        }
        long timeDifferenceMillis = this.lastMillis.get() - currentMillis;
        ShardingSpherePreconditions.checkState((timeDifferenceMillis < (long)this.maxTolerateTimeDifferenceMillis ? 1 : 0) != 0, () -> new AlgorithmExecuteException((ShardingSphereAlgorithm)this, "Clock is moving backwards, last time is %d milliseconds, current time is %d milliseconds.", new Object[]{this.lastMillis.get(), currentMillis}));
        Thread.sleep(timeDifferenceMillis);
        return true;
    }

    private long waitUntilNextTime(long lastTime) {
        long result = timeService.getCurrentMillis();
        while (result <= lastTime) {
            result = timeService.getCurrentMillis();
        }
        return result;
    }

    private void vibrateSequenceOffset() {
        if (!this.sequenceOffset.compareAndSet(this.maxVibrationOffset, 0)) {
            this.sequenceOffset.incrementAndGet();
        }
    }

    private int getWorkerId() {
        return null == this.computeNodeInstanceContext.get() ? 0 : this.computeNodeInstanceContext.get().getWorkerId();
    }

    public String getType() {
        return "SNOWFLAKE";
    }

    public boolean isDefault() {
        return true;
    }

    @Generated
    public static void setTimeService(TimeService timeService) {
        SnowflakeKeyGenerateAlgorithm.timeService = timeService;
    }

    static {
        timeService = new TimeService();
        EPOCH = LocalDateTime.of(2016, 11, 1, 0, 0, 0).toInstant(ZoneId.systemDefault().getRules().getOffset(Instant.now())).toEpochMilli();
    }
}

