/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.err;

import com.google.common.base.Strings;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.external.sql.vendor.VendorError;
import org.apache.shardingsphere.infra.exception.dialect.SQLExceptionTransformEngine;
import org.apache.shardingsphere.infra.exception.mysql.vendor.MySQLVendorError;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class MySQLErrorPacketFactory {
    private static final DatabaseType DATABASE_TYPE = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL");

    public static MySQLErrPacket newInstance(Exception cause) {
        SQLException sqlException = SQLExceptionTransformEngine.toSQLException((Exception)cause, (DatabaseType)DATABASE_TYPE);
        return null == sqlException.getSQLState() ? new MySQLErrPacket((VendorError)MySQLVendorError.ER_INTERNAL_ERROR, new Object[]{MySQLErrorPacketFactory.getErrorMessage(sqlException)}) : new MySQLErrPacket(sqlException);
    }

    private static String getErrorMessage(SQLException cause) {
        return null == cause.getNextException() || !Strings.isNullOrEmpty((String)cause.getMessage()) ? cause.getMessage() : cause.getNextException().getMessage();
    }

    @Generated
    private MySQLErrorPacketFactory() {
    }
}

