/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.encrypt.config.rule.EncryptColumnItemRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.statement.ShowEncryptRulesStatement;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowEncryptRuleExecutor
implements DistSQLQueryExecutor<ShowEncryptRulesStatement>,
DistSQLExecutorRuleAware<EncryptRule> {
    private EncryptRule rule;

    public Collection<String> getColumnNames(ShowEncryptRulesStatement sqlStatement) {
        return Arrays.asList("table", "logic_column", "cipher_column", "assisted_query_column", "like_query_column", "encryptor_type", "encryptor_props", "assisted_query_type", "assisted_query_props", "like_query_type", "like_query_props");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowEncryptRulesStatement sqlStatement, ContextManager contextManager) {
        return this.rule.getConfiguration().getTables().stream().filter(each -> null == sqlStatement.getTableName() || each.getName().equalsIgnoreCase(sqlStatement.getTableName())).map(each -> this.buildColumnData((EncryptTableRuleConfiguration)each, this.rule.getConfiguration().getEncryptors())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<LocalDataQueryResultRow> buildColumnData(EncryptTableRuleConfiguration tableRuleConfig, Map<String, AlgorithmConfiguration> encryptors) {
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        for (EncryptColumnRuleConfiguration each : tableRuleConfig.getColumns()) {
            AlgorithmConfiguration encryptorAlgorithmConfig = encryptors.get(each.getCipher().getEncryptorName());
            Optional<AlgorithmConfiguration> assistedQueryEncryptorAlgorithmConfig = each.getAssistedQuery().map(optional -> (AlgorithmConfiguration)encryptors.get(optional.getEncryptorName()));
            Optional<AlgorithmConfiguration> likeQueryEncryptorAlgorithmConfig = each.getLikeQuery().map(optional -> (AlgorithmConfiguration)encryptors.get(optional.getEncryptorName()));
            result.add(new LocalDataQueryResultRow(new Object[]{tableRuleConfig.getName(), each.getName(), each.getCipher().getName(), each.getAssistedQuery().map(EncryptColumnItemRuleConfiguration::getName), each.getLikeQuery().map(EncryptColumnItemRuleConfiguration::getName), encryptorAlgorithmConfig.getType(), encryptorAlgorithmConfig.getProps(), assistedQueryEncryptorAlgorithmConfig.map(AlgorithmConfiguration::getType), assistedQueryEncryptorAlgorithmConfig.map(AlgorithmConfiguration::getProps), likeQueryEncryptorAlgorithmConfig.map(AlgorithmConfiguration::getType), likeQueryEncryptorAlgorithmConfig.map(AlgorithmConfiguration::getProps)}));
        }
        return result;
    }

    public Class<EncryptRule> getRuleClass() {
        return EncryptRule.class;
    }

    public Class<ShowEncryptRulesStatement> getType() {
        return ShowEncryptRulesStatement.class;
    }

    @Generated
    public void setRule(EncryptRule rule) {
        this.rule = rule;
    }
}

