/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sqlfederation.config.SQLFederationRuleConfiguration;
import org.apache.shardingsphere.sqlfederation.distsql.statement.queryable.ShowSQLFederationRuleStatement;
import org.apache.shardingsphere.sqlfederation.rule.SQLFederationRule;

public final class ShowSQLFederationRuleExecutor
implements DistSQLQueryExecutor<ShowSQLFederationRuleStatement>,
DistSQLExecutorRuleAware<SQLFederationRule> {
    private SQLFederationRule rule;

    public Collection<String> getColumnNames(ShowSQLFederationRuleStatement sqlStatement) {
        return Arrays.asList("sql_federation_enabled", "all_query_use_sql_federation", "execution_plan_cache");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowSQLFederationRuleStatement sqlStatement, ContextManager contextManager) {
        SQLFederationRuleConfiguration ruleConfig = this.rule.getConfiguration();
        boolean sqlFederationEnabled = ruleConfig.isSqlFederationEnabled();
        boolean allQueryUseSQLFederation = ruleConfig.isAllQueryUseSQLFederation();
        String executionPlanCache = String.valueOf(ruleConfig.getExecutionPlanCache());
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{sqlFederationEnabled, allQueryUseSQLFederation, executionPlanCache}));
    }

    public Class<SQLFederationRule> getRuleClass() {
        return SQLFederationRule.class;
    }

    public Class<ShowSQLFederationRuleStatement> getType() {
        return ShowSQLFederationRuleStatement.class;
    }

    @Generated
    public void setRule(SQLFederationRule rule) {
        this.rule = rule;
    }
}

