/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.yaml.swapper;

import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sqlfederation.config.SQLFederationRuleConfiguration;
import org.apache.shardingsphere.sqlfederation.yaml.config.YamlSQLFederationRuleConfiguration;
import org.apache.shardingsphere.sqlfederation.yaml.swapper.YamlSQLFederationExecutionPlanCacheConfigurationSwapper;

public final class YamlSQLFederationRuleConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlSQLFederationRuleConfiguration, SQLFederationRuleConfiguration> {
    private final YamlSQLFederationExecutionPlanCacheConfigurationSwapper executionPlanCacheConfigSwapper = new YamlSQLFederationExecutionPlanCacheConfigurationSwapper();

    public YamlSQLFederationRuleConfiguration swapToYamlConfiguration(SQLFederationRuleConfiguration data) {
        YamlSQLFederationRuleConfiguration result = new YamlSQLFederationRuleConfiguration();
        result.setSqlFederationEnabled(data.isSqlFederationEnabled());
        result.setAllQueryUseSQLFederation(data.isAllQueryUseSQLFederation());
        result.setExecutionPlanCache(this.executionPlanCacheConfigSwapper.swapToYamlConfiguration(data.getExecutionPlanCache()));
        return result;
    }

    public SQLFederationRuleConfiguration swapToObject(YamlSQLFederationRuleConfiguration yamlConfig) {
        CacheOption executionPlanCacheConfig = this.executionPlanCacheConfigSwapper.swapToObject(yamlConfig.getExecutionPlanCache());
        return new SQLFederationRuleConfiguration(yamlConfig.isSqlFederationEnabled(), yamlConfig.isAllQueryUseSQLFederation(), executionPlanCacheConfig);
    }

    public Class<SQLFederationRuleConfiguration> getTypeClass() {
        return SQLFederationRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SQL_FEDERATION";
    }

    public int getOrder() {
        return 1000;
    }
}

