/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck.table;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.PipelineCancellable;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.SingleTableInventoryCalculatedResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableDataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.yaml.YamlTableDataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.yaml.YamlTableDataConsistencyCheckResultSwapper;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryCheckParameter;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.SingleTableInventoryCalculateParameter;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.SingleTableInventoryCalculator;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobUpdateProgress;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.kernel.category.PipelineSQLException;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;
import org.apache.shardingsphere.infra.util.close.QuietlyCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MatchingTableInventoryChecker
implements TableInventoryChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MatchingTableInventoryChecker.class);
    private final TableInventoryCheckParameter param;
    private final AtomicBoolean canceling = new AtomicBoolean(false);
    private volatile SingleTableInventoryCalculator sourceCalculator;
    private volatile SingleTableInventoryCalculator targetCalculator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableDataConsistencyCheckResult checkSingleTableInventoryData() {
        ThreadFactory threadFactory = ExecutorThreadFactoryBuilder.build((String)(this.param.getJobId() + "-matching-check-%d"));
        ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2), threadFactory);
        try {
            TableDataConsistencyCheckResult tableDataConsistencyCheckResult = this.checkSingleTableInventoryData(this.param, executor);
            return tableDataConsistencyCheckResult;
        }
        finally {
            executor.shutdown();
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableDataConsistencyCheckResult checkSingleTableInventoryData(TableInventoryCheckParameter param, ThreadPoolExecutor executor) {
        SingleTableInventoryCalculator targetCalculator;
        SingleTableInventoryCalculator sourceCalculator;
        SingleTableInventoryCalculateParameter sourceParam = new SingleTableInventoryCalculateParameter(param.getSourceDataSource(), param.getSourceTable(), param.getColumnNames(), param.getUniqueKeys(), param.getProgressContext().getSourceTableCheckPositions().get(param.getSourceTable().getTableName()));
        SingleTableInventoryCalculateParameter targetParam = new SingleTableInventoryCalculateParameter(param.getTargetDataSource(), param.getTargetTable(), param.getColumnNames(), param.getUniqueKeys(), param.getProgressContext().getTargetTableCheckPositions().get(param.getTargetTable().getTableName()));
        this.sourceCalculator = sourceCalculator = this.buildSingleTableInventoryCalculator();
        this.targetCalculator = targetCalculator = this.buildSingleTableInventoryCalculator();
        try {
            Iterator<SingleTableInventoryCalculatedResult> sourceCalculatedResults = this.waitFuture(executor.submit(() -> sourceCalculator.calculate(sourceParam))).iterator();
            Iterator<SingleTableInventoryCalculatedResult> targetCalculatedResults = this.waitFuture(executor.submit(() -> targetCalculator.calculate(targetParam))).iterator();
            TableDataConsistencyCheckResult tableDataConsistencyCheckResult = this.checkSingleTableInventoryData(sourceCalculatedResults, targetCalculatedResults, param, executor);
            return tableDataConsistencyCheckResult;
        }
        finally {
            QuietlyCloser.close((AutoCloseable)sourceParam.getCalculationContext());
            QuietlyCloser.close((AutoCloseable)targetParam.getCalculationContext());
            this.sourceCalculator = null;
            this.targetCalculator = null;
        }
    }

    private TableDataConsistencyCheckResult checkSingleTableInventoryData(Iterator<SingleTableInventoryCalculatedResult> sourceCalculatedResults, Iterator<SingleTableInventoryCalculatedResult> targetCalculatedResults, TableInventoryCheckParameter param, ThreadPoolExecutor executor) {
        YamlTableDataConsistencyCheckResult checkResult = new YamlTableDataConsistencyCheckResult(true);
        while (sourceCalculatedResults.hasNext() && targetCalculatedResults.hasNext()) {
            if (null != param.getReadRateLimitAlgorithm()) {
                param.getReadRateLimitAlgorithm().intercept(PipelineSQLOperationType.SELECT, 1);
            }
            SingleTableInventoryCalculatedResult sourceCalculatedResult = this.waitFuture(executor.submit(sourceCalculatedResults::next));
            SingleTableInventoryCalculatedResult targetCalculatedResult = this.waitFuture(executor.submit(targetCalculatedResults::next));
            if (!Objects.equals(sourceCalculatedResult, targetCalculatedResult)) {
                checkResult.setMatched(false);
                log.info("content matched false, jobId={}, sourceTable={}, targetTable={}, uniqueKeys={}", new Object[]{param.getJobId(), param.getSourceTable(), param.getTargetTable(), param.getUniqueKeys()});
                break;
            }
            if (sourceCalculatedResult.getMaxUniqueKeyValue().isPresent()) {
                param.getProgressContext().getSourceTableCheckPositions().put(param.getSourceTable().getTableName(), sourceCalculatedResult.getMaxUniqueKeyValue().get());
            }
            if (targetCalculatedResult.getMaxUniqueKeyValue().isPresent()) {
                param.getProgressContext().getTargetTableCheckPositions().put(param.getTargetTable().getTableName(), targetCalculatedResult.getMaxUniqueKeyValue().get());
            }
            param.getProgressContext().onProgressUpdated(new PipelineJobUpdateProgress(sourceCalculatedResult.getRecordsCount()));
        }
        if (sourceCalculatedResults.hasNext()) {
            checkResult.setMatched(false);
            return new YamlTableDataConsistencyCheckResultSwapper().swapToObject(checkResult);
        }
        if (targetCalculatedResults.hasNext()) {
            checkResult.setMatched(false);
            return new YamlTableDataConsistencyCheckResultSwapper().swapToObject(checkResult);
        }
        return new YamlTableDataConsistencyCheckResultSwapper().swapToObject(checkResult);
    }

    private <T> T waitFuture(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new SQLWrapperException(new SQLException(ex));
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof PipelineSQLException) {
                throw (PipelineSQLException)ex.getCause();
            }
            throw new SQLWrapperException(new SQLException(ex));
        }
    }

    protected abstract SingleTableInventoryCalculator buildSingleTableInventoryCalculator();

    @Override
    public void cancel() {
        this.canceling.set(true);
        Optional.ofNullable(this.sourceCalculator).ifPresent(PipelineCancellable::cancel);
        Optional.ofNullable(this.targetCalculator).ifPresent(PipelineCancellable::cancel);
    }

    @Override
    public boolean isCanceling() {
        return this.canceling.get();
    }

    @Generated
    public MatchingTableInventoryChecker(TableInventoryCheckParameter param) {
        this.param = param;
    }
}

