/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.exception.job;

import com.google.common.base.Preconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.sqlstate.SQLState;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.kernel.category.PipelineSQLException;

public abstract class PipelineJobException
extends PipelineSQLException {
    private static final long serialVersionUID = -5622432104488993484L;
    private static final int JOB_CODE = 1;

    protected PipelineJobException(SQLState sqlState, int errorCode, String reason) {
        super(sqlState, PipelineJobException.getErrorCode(errorCode), reason);
    }

    protected PipelineJobException(SQLState sqlState, int errorCode, String reason, Exception cause) {
        super(sqlState, PipelineJobException.getErrorCode(errorCode), reason, cause);
    }

    private static int getErrorCode(int errorCode) {
        Preconditions.checkArgument((errorCode >= 0 && errorCode < 100 ? 1 : 0) != 0, (Object)"The value range of error code should be [0, 100).");
        return 100 + errorCode;
    }
}

