/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJob;
import org.apache.shardingsphere.data.pipeline.core.task.runner.PipelineTasksRunner;

public final class PipelineJobRegistry {
    private static final Map<String, PipelineJob> JOBS = new ConcurrentHashMap<String, PipelineJob>();

    public static void add(String jobId, PipelineJob job) {
        JOBS.put(jobId, job);
    }

    public static boolean isExisting(String jobId) {
        return JOBS.containsKey(jobId);
    }

    public static PipelineJob get(String jobId) {
        return JOBS.get(jobId);
    }

    public static void stop(String jobId) {
        PipelineJob job = JOBS.get(jobId);
        if (null == job) {
            return;
        }
        job.getJobRunnerManager().stop();
        JOBS.remove(jobId);
    }

    public static Optional<PipelineJobItemContext> getItemContext(String jobId, int shardingItem) {
        return JOBS.containsKey(jobId) ? JOBS.get(jobId).getJobRunnerManager().getTasksRunner(shardingItem).map(PipelineTasksRunner::getJobItemContext) : Optional.empty();
    }

    public static Collection<Integer> getShardingItems(String jobId) {
        return JOBS.containsKey(jobId) ? JOBS.get(jobId).getJobRunnerManager().getShardingItems() : Collections.emptyList();
    }

    @Generated
    private PipelineJobRegistry() {
    }
}

