/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.props.domain.synonym;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public abstract class PropertySynonyms {
    private final Collection<String> standardPropertyKeys;
    private final Map<String, Object> standardProperties;
    private final Map<String, Object> localProperties;

    protected PropertySynonyms(Map<String, Object> props, Collection<String> standardPropertyKeys, Map<String, String> propertySynonyms) {
        this.standardPropertyKeys = standardPropertyKeys;
        this.standardProperties = this.buildStandardProperties(props, standardPropertyKeys, propertySynonyms);
        this.localProperties = this.buildLocalProperties(props, standardPropertyKeys, propertySynonyms);
    }

    private Map<String, Object> buildStandardProperties(Map<String, Object> props, Collection<String> standardPropertyKeys, Map<String, String> propertySynonyms) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(standardPropertyKeys.size(), 1.0f);
        for (String each : standardPropertyKeys) {
            if (props.containsKey(each)) {
                result.put(each, props.get(each));
                continue;
            }
            if (!props.containsKey(propertySynonyms.get(each))) continue;
            result.put(each, props.get(propertySynonyms.get(each)));
        }
        return result;
    }

    private Map<String, Object> buildLocalProperties(Map<String, Object> props, Collection<String> standardPropertyKeys, Map<String, String> propertySynonyms) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(standardPropertyKeys.size(), 1.0f);
        for (String each : this.getLocalPropertyKeys(standardPropertyKeys, propertySynonyms)) {
            if (!props.containsKey(each)) continue;
            result.put(each, props.get(each));
        }
        for (String each : standardPropertyKeys) {
            if (!props.containsKey(each)) continue;
            result.put(propertySynonyms.getOrDefault(each, each), props.get(each));
        }
        return result;
    }

    private Collection<String> getLocalPropertyKeys(Collection<String> standardPropertyKey, Map<String, String> propertySynonyms) {
        return standardPropertyKey.stream().filter(propertySynonyms::containsKey).map(propertySynonyms::get).collect(Collectors.toSet());
    }

    @Generated
    public Collection<String> getStandardPropertyKeys() {
        return this.standardPropertyKeys;
    }

    @Generated
    public Map<String, Object> getStandardProperties() {
        return this.standardProperties;
    }

    @Generated
    public Map<String, Object> getLocalProperties() {
        return this.localProperties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertySynonyms)) {
            return false;
        }
        PropertySynonyms other = (PropertySynonyms)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<String> this$standardPropertyKeys = this.getStandardPropertyKeys();
        Collection<String> other$standardPropertyKeys = other.getStandardPropertyKeys();
        if (this$standardPropertyKeys == null ? other$standardPropertyKeys != null : !((Object)this$standardPropertyKeys).equals(other$standardPropertyKeys)) {
            return false;
        }
        Map<String, Object> this$standardProperties = this.getStandardProperties();
        Map<String, Object> other$standardProperties = other.getStandardProperties();
        if (this$standardProperties == null ? other$standardProperties != null : !((Object)this$standardProperties).equals(other$standardProperties)) {
            return false;
        }
        Map<String, Object> this$localProperties = this.getLocalProperties();
        Map<String, Object> other$localProperties = other.getLocalProperties();
        return !(this$localProperties == null ? other$localProperties != null : !((Object)this$localProperties).equals(other$localProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropertySynonyms;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<String> $standardPropertyKeys = this.getStandardPropertyKeys();
        result = result * 59 + ($standardPropertyKeys == null ? 43 : ((Object)$standardPropertyKeys).hashCode());
        Map<String, Object> $standardProperties = this.getStandardProperties();
        result = result * 59 + ($standardProperties == null ? 43 : ((Object)$standardProperties).hashCode());
        Map<String, Object> $localProperties = this.getLocalProperties();
        result = result * 59 + ($localProperties == null ? 43 : ((Object)$localProperties).hashCode());
        return result;
    }
}

