/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.retriever;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.DeleteStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.shadow.route.retriever.ShadowDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.route.retriever.dml.ShadowDMLStatementDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.route.retriever.hint.ShadowHintDataSourceMappingsRetriever;
import org.apache.shardingsphere.shadow.spi.ShadowOperationType;

public final class ShadowDataSourceMappingsRetrieverFactory {
    public static ShadowDataSourceMappingsRetriever newInstance(QueryContext queryContext) {
        Optional<ShadowOperationType> operationType = ShadowDataSourceMappingsRetrieverFactory.getShadowOperationType(queryContext.getSqlStatementContext());
        return operationType.isPresent() ? new ShadowDMLStatementDataSourceMappingsRetriever(queryContext, operationType.get()) : new ShadowHintDataSourceMappingsRetriever(queryContext.getHintValueContext());
    }

    private static Optional<ShadowOperationType> getShadowOperationType(SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext instanceof InsertStatementContext) {
            return Optional.of(ShadowOperationType.INSERT);
        }
        if (sqlStatementContext instanceof DeleteStatementContext) {
            return Optional.of(ShadowOperationType.DELETE);
        }
        if (sqlStatementContext instanceof UpdateStatementContext) {
            return Optional.of(ShadowOperationType.UPDATE);
        }
        if (sqlStatementContext instanceof SelectStatementContext) {
            return Optional.of(ShadowOperationType.SELECT);
        }
        return Optional.empty();
    }

    @Generated
    private ShadowDataSourceMappingsRetrieverFactory() {
    }
}

