/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptColumnAlterException;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAlterTableToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptColumnToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.column.item.AssistedQueryColumnItem;
import org.apache.shardingsphere.encrypt.rule.column.item.LikeQueryColumnItem;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.AlterTableStatementContext;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Substitutable;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.RemoveToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ChangeColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.position.ColumnPositionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;

public final class EncryptAlterTableTokenGenerator
implements CollectionSQLTokenGenerator<AlterTableStatementContext> {
    private final EncryptRule rule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof AlterTableStatementContext;
    }

    public Collection<SQLToken> generateSQLTokens(AlterTableStatementContext sqlStatementContext) {
        String tableName = sqlStatementContext.getSqlStatement().getTable().getTableName().getIdentifier().getValue();
        EncryptTable encryptTable = this.rule.getEncryptTable(tableName);
        LinkedList<SQLToken> result = new LinkedList<SQLToken>(this.getAddColumnTokens(encryptTable, sqlStatementContext.getSqlStatement().getAddColumnDefinitions()));
        result.addAll(this.getModifyColumnTokens(encryptTable, sqlStatementContext.getSqlStatement().getModifyColumnDefinitions()));
        result.addAll(this.getChangeColumnTokens(encryptTable, sqlStatementContext.getSqlStatement().getChangeColumnDefinitions()));
        List<SQLToken> dropColumnTokens = this.getDropColumnTokens(encryptTable, sqlStatementContext.getSqlStatement().getDropColumnDefinitions());
        String databaseName = sqlStatementContext.getDatabaseType().getType();
        if ("SQLServer".equals(databaseName)) {
            result.addAll(this.mergeDropColumnStatement(dropColumnTokens, "", ""));
        } else if ("Oracle".equals(databaseName)) {
            result.addAll(this.mergeDropColumnStatement(dropColumnTokens, "(", ")"));
        } else {
            result.addAll(dropColumnTokens);
        }
        return result;
    }

    private Collection<SQLToken> getAddColumnTokens(EncryptTable encryptTable, Collection<AddColumnDefinitionSegment> segments) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (AddColumnDefinitionSegment each : segments) {
            result.addAll(this.getAddColumnTokens(encryptTable, each));
        }
        return result;
    }

    private Collection<SQLToken> getAddColumnTokens(EncryptTable encryptTable, AddColumnDefinitionSegment segment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ColumnDefinitionSegment each : segment.getColumnDefinitions()) {
            String columnName = each.getColumnName().getIdentifier().getValue();
            if (!encryptTable.isEncryptColumn(columnName)) continue;
            result.addAll(this.getAddColumnTokens(encryptTable.getEncryptColumn(columnName), segment, each));
        }
        this.getAddColumnPositionToken(encryptTable, segment).ifPresent(result::add);
        return result;
    }

    private Collection<SQLToken> getAddColumnTokens(EncryptColumn encryptColumn, AddColumnDefinitionSegment addColumnDefinitionSegment, ColumnDefinitionSegment columnDefinitionSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        result.add((SQLToken)new RemoveToken(columnDefinitionSegment.getStartIndex(), columnDefinitionSegment.getStopIndex()));
        result.add(new EncryptColumnToken(columnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getStopIndex(), encryptColumn.getCipher().getName(), "VARCHAR(4000)"));
        encryptColumn.getAssistedQuery().map(optional -> new EncryptColumnToken(addColumnDefinitionSegment.getStopIndex() + 1, addColumnDefinitionSegment.getStopIndex(), ", ADD COLUMN " + optional.getName(), "VARCHAR(4000)")).ifPresent(result::add);
        encryptColumn.getLikeQuery().map(optional -> new EncryptColumnToken(addColumnDefinitionSegment.getStopIndex() + 1, addColumnDefinitionSegment.getStopIndex(), ", ADD COLUMN " + optional.getName(), "VARCHAR(4000)")).ifPresent(result::add);
        return result;
    }

    private Optional<SQLToken> getAddColumnPositionToken(EncryptTable encryptTable, AddColumnDefinitionSegment segment) {
        String columnName;
        Optional<ColumnPositionSegment> columnPositionSegment = segment.getColumnPosition().filter(optional -> null != optional.getColumnName());
        if (columnPositionSegment.isPresent() && encryptTable.isEncryptColumn(columnName = columnPositionSegment.get().getColumnName().getIdentifier().getValue())) {
            return Optional.of(this.getPositionColumnToken(encryptTable.getEncryptColumn(columnName), (ColumnPositionSegment)segment.getColumnPosition().get()));
        }
        return Optional.empty();
    }

    private EncryptAlterTableToken getPositionColumnToken(EncryptColumn encryptColumn, ColumnPositionSegment segment) {
        return new EncryptAlterTableToken(segment.getColumnName().getStartIndex(), segment.getStopIndex(), encryptColumn.getCipher().getName(), null);
    }

    private Collection<SQLToken> getModifyColumnTokens(EncryptTable encryptTable, Collection<ModifyColumnDefinitionSegment> segments) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ModifyColumnDefinitionSegment each : segments) {
            String columnName = each.getColumnDefinition().getColumnName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((!encryptTable.isEncryptColumn(columnName) ? 1 : 0) != 0, () -> new UnsupportedOperationException("Unsupported operation 'modify' for the cipher column"));
            each.getColumnPosition().flatMap(optional -> this.getColumnPositionToken(encryptTable, (ColumnPositionSegment)optional)).ifPresent(result::add);
        }
        return result;
    }

    private Optional<SQLToken> getColumnPositionToken(EncryptTable encryptTable, ColumnPositionSegment segment) {
        if (null == segment.getColumnName()) {
            return Optional.empty();
        }
        String columnName = segment.getColumnName().getIdentifier().getValue();
        return encryptTable.isEncryptColumn(columnName) ? Optional.of(this.getPositionColumnToken(encryptTable.getEncryptColumn(columnName), segment)) : Optional.empty();
    }

    private Collection<SQLToken> getChangeColumnTokens(EncryptTable encryptTable, Collection<ChangeColumnDefinitionSegment> segments) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ChangeColumnDefinitionSegment each : segments) {
            String columnName = each.getPreviousColumn().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((!encryptTable.isEncryptColumn(columnName) ? 1 : 0) != 0, () -> new UnsupportedOperationException("Unsupported operation 'change' for the cipher column"));
            result.addAll(this.getChangeColumnTokens(encryptTable, each));
            each.getColumnPosition().flatMap(optional -> this.getColumnPositionToken(encryptTable, (ColumnPositionSegment)optional)).ifPresent(result::add);
        }
        return result;
    }

    private Collection<SQLToken> getChangeColumnTokens(EncryptTable encryptTable, ChangeColumnDefinitionSegment segment) {
        String previousColumnName = segment.getPreviousColumn().getIdentifier().getValue();
        String columnName = segment.getColumnDefinition().getColumnName().getIdentifier().getValue();
        this.isSameEncryptColumn(encryptTable, previousColumnName, columnName);
        if (!encryptTable.isEncryptColumn(columnName) || !encryptTable.isEncryptColumn(previousColumnName)) {
            return Collections.emptyList();
        }
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        EncryptColumn previousEncryptColumn = encryptTable.getEncryptColumn(previousColumnName);
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
        result.addAll(this.getPreviousColumnTokens(previousEncryptColumn, segment));
        result.addAll(this.getColumnTokens(previousEncryptColumn, encryptColumn, segment));
        return result;
    }

    private void isSameEncryptColumn(EncryptTable encryptTable, String previousColumnName, String columnName) {
        Optional<EncryptAlgorithm> previousEncryptor = encryptTable.findEncryptor(previousColumnName);
        Optional<EncryptAlgorithm> currentEncryptor = encryptTable.findEncryptor(columnName);
        if (!previousEncryptor.isPresent() && !currentEncryptor.isPresent()) {
            return;
        }
        ShardingSpherePreconditions.checkState((previousEncryptor.equals(currentEncryptor) && this.checkPreviousAndAfterHasSameColumnNumber(encryptTable, previousColumnName, columnName) ? 1 : 0) != 0, () -> new EncryptColumnAlterException(encryptTable.getTable(), columnName, previousColumnName));
    }

    private boolean checkPreviousAndAfterHasSameColumnNumber(EncryptTable encryptTable, String previousColumnName, String columnName) {
        EncryptColumn previousEncryptColumn = encryptTable.getEncryptColumn(previousColumnName);
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
        if (previousEncryptColumn.getAssistedQuery().isPresent() && !encryptColumn.getAssistedQuery().isPresent()) {
            return false;
        }
        if (previousEncryptColumn.getLikeQuery().isPresent() && !encryptColumn.getLikeQuery().isPresent()) {
            return false;
        }
        return previousEncryptColumn.getAssistedQuery().isPresent() || !encryptColumn.getAssistedQuery().isPresent();
    }

    private Collection<SQLToken> getPreviousColumnTokens(EncryptColumn previousEncryptColumn, ChangeColumnDefinitionSegment segment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        result.add((SQLToken)new RemoveToken(segment.getPreviousColumn().getStartIndex(), segment.getPreviousColumn().getStopIndex()));
        result.add(new EncryptAlterTableToken(segment.getPreviousColumn().getStopIndex() + 1, segment.getPreviousColumn().getStopIndex(), previousEncryptColumn.getCipher().getName(), null));
        return result;
    }

    private Collection<SQLToken> getColumnTokens(EncryptColumn previousEncryptColumn, EncryptColumn encryptColumn, ChangeColumnDefinitionSegment segment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        result.add((SQLToken)new RemoveToken(segment.getColumnDefinition().getColumnName().getStartIndex(), segment.getColumnDefinition().getStopIndex()));
        result.add(new EncryptColumnToken(segment.getColumnDefinition().getStopIndex() + 1, segment.getColumnDefinition().getStopIndex(), encryptColumn.getCipher().getName(), "VARCHAR(4000)"));
        previousEncryptColumn.getAssistedQuery().map(optional -> new EncryptColumnToken(segment.getStopIndex() + 1, segment.getStopIndex(), ", CHANGE COLUMN " + optional.getName() + " " + encryptColumn.getAssistedQuery().map(AssistedQueryColumnItem::getName).orElse(""), "VARCHAR(4000)")).ifPresent(result::add);
        previousEncryptColumn.getLikeQuery().map(optional -> new EncryptColumnToken(segment.getStopIndex() + 1, segment.getStopIndex(), ", CHANGE COLUMN " + optional.getName() + " " + encryptColumn.getLikeQuery().map(LikeQueryColumnItem::getName).orElse(""), "VARCHAR(4000)")).ifPresent(result::add);
        return result;
    }

    private List<SQLToken> getDropColumnTokens(EncryptTable encryptTable, Collection<DropColumnDefinitionSegment> segments) {
        ArrayList<SQLToken> result = new ArrayList<SQLToken>();
        for (DropColumnDefinitionSegment each : segments) {
            result.addAll(this.getDropColumnTokens(encryptTable, each));
        }
        return result;
    }

    private Collection<SQLToken> getDropColumnTokens(EncryptTable encryptTable, DropColumnDefinitionSegment segment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ColumnSegment each : segment.getColumns()) {
            ShardingSpherePreconditions.checkState((!encryptTable.isEncryptColumn(each.getQualifiedName()) ? 1 : 0) != 0, () -> new UnsupportedOperationException("Unsupported operation 'drop' for the cipher column"));
        }
        return result;
    }

    private Collection<SQLToken> mergeDropColumnStatement(List<SQLToken> dropSQLTokens, String leftJoiner, String rightJoiner) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        LinkedList<String> dropColumns = new LinkedList<String>();
        int lastStartIndex = -1;
        for (int i = 0; i < dropSQLTokens.size(); ++i) {
            SQLToken token = dropSQLTokens.get(i);
            if (token instanceof RemoveToken) {
                result.add((SQLToken)(0 == i ? token : new RemoveToken(lastStartIndex, token.getStopIndex())));
            } else {
                EncryptAlterTableToken encryptAlterTableToken = (EncryptAlterTableToken)token;
                dropColumns.add(encryptAlterTableToken.getColumnName());
                if (i == dropSQLTokens.size() - 1) {
                    result.add(new EncryptAlterTableToken(token.getStartIndex(), encryptAlterTableToken.getStopIndex(), leftJoiner + String.join((CharSequence)",", dropColumns) + rightJoiner, "DROP COLUMN"));
                }
            }
            lastStartIndex = ((Substitutable)token).getStartIndex();
        }
        return result;
    }

    @Generated
    public EncryptAlterTableTokenGenerator(EncryptRule rule) {
        this.rule = rule;
    }
}

