/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.projection;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParenthesesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptProjectionTokenGenerator {
    private final List<SQLToken> previousSQLTokens;
    private final EncryptRule rule;
    private final DatabaseType databaseType;

    public Collection<SQLToken> generateSQLTokens(SelectStatementContext selectStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        selectStatementContext.getSubqueryContexts().values().stream().map(this::generateSQLTokens).forEach(result::addAll);
        result.addAll(this.generateSelectSQLTokens(selectStatementContext));
        return result;
    }

    private Collection<SQLToken> generateSelectSQLTokens(SelectStatementContext selectStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        CaseInsensitiveSet existColumnNames = new CaseInsensitiveSet();
        for (ProjectionSegment each : selectStatementContext.getSqlStatement().getProjections().getProjections()) {
            ShorthandProjectionSegment shorthandSegment;
            Collection actualColumns;
            if (each instanceof ColumnProjectionSegment) {
                this.generateSQLToken(selectStatementContext, (ColumnProjectionSegment)each, (Collection<String>)existColumnNames).ifPresent(result::add);
            }
            if (!(each instanceof ShorthandProjectionSegment) || (actualColumns = this.getShorthandProjection(shorthandSegment = (ShorthandProjectionSegment)each, selectStatementContext.getProjectionsContext()).getActualColumns()).isEmpty()) continue;
            result.add((SQLToken)this.generateSQLToken(shorthandSegment, actualColumns, selectStatementContext, selectStatementContext.getSubqueryType(), (Collection<String>)existColumnNames));
        }
        return result;
    }

    private Optional<SubstitutableColumnNameToken> generateSQLToken(SelectStatementContext selectStatementContext, ColumnProjectionSegment columnSegment, Collection<String> existColumnNames) {
        ColumnProjection columnProjection = this.buildColumnProjection(columnSegment);
        String columnName = columnProjection.getOriginalColumn().getValue();
        boolean newAddedColumn = existColumnNames.add(columnProjection.getOriginalTable().getValue() + "." + columnName);
        Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(columnProjection.getOriginalTable().getValue());
        if (encryptTable.isPresent() && encryptTable.get().isEncryptColumn(columnName)) {
            EncryptColumn encryptColumn = encryptTable.get().getEncryptColumn(columnName);
            Collection<Projection> projections = this.generateProjections(encryptColumn, columnProjection, selectStatementContext.getSubqueryType(), newAddedColumn);
            int startIndex = this.getStartIndex(columnSegment);
            int stopIndex = this.getStopIndex(columnSegment);
            this.previousSQLTokens.removeIf(each -> each.getStartIndex() == startIndex);
            return Optional.of(new SubstitutableColumnNameToken(startIndex, stopIndex, projections, this.databaseType));
        }
        return Optional.empty();
    }

    private SubstitutableColumnNameToken generateSQLToken(ShorthandProjectionSegment segment, Collection<Projection> actualColumns, SelectStatementContext selectStatementContext, SubqueryType subqueryType, Collection<String> existColumnNames) {
        LinkedList<Projection> projections = new LinkedList<Projection>();
        for (Projection each2 : actualColumns) {
            if (each2 instanceof ColumnProjection) {
                ColumnProjection columnProjection = (ColumnProjection)each2;
                boolean newAddedColumn = existColumnNames.add(columnProjection.getOriginalTable().getValue() + "." + columnProjection.getOriginalColumn().getValue());
                Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(columnProjection.getOriginalTable().getValue());
                if (encryptTable.isPresent() && encryptTable.get().isEncryptColumn(columnProjection.getOriginalColumn().getValue())) {
                    EncryptColumn encryptColumn = encryptTable.get().getEncryptColumn(columnProjection.getOriginalColumn().getValue());
                    projections.addAll(this.generateProjections(encryptColumn, columnProjection, subqueryType, newAddedColumn));
                    continue;
                }
            }
            projections.add(each2.getAlias().filter(alias -> !DerivedColumn.isDerivedColumnName((String)alias.getValue())).map(optional -> new ColumnProjection(null, optional, null, this.databaseType)).orElse(each2));
        }
        int startIndex = segment.getOwner().isPresent() ? ((OwnerSegment)segment.getOwner().get()).getStartIndex() : segment.getStartIndex();
        this.previousSQLTokens.removeIf(each -> each.getStartIndex() == startIndex);
        return new SubstitutableColumnNameToken(startIndex, segment.getStopIndex(), projections, selectStatementContext.getDatabaseType());
    }

    private int getStartIndex(ColumnProjectionSegment columnSegment) {
        if (columnSegment.getColumn().getLeftParentheses().isPresent()) {
            return ((ParenthesesSegment)columnSegment.getColumn().getLeftParentheses().get()).getStartIndex();
        }
        return columnSegment.getColumn().getOwner().isPresent() ? ((OwnerSegment)columnSegment.getColumn().getOwner().get()).getStartIndex() : columnSegment.getColumn().getStartIndex();
    }

    private int getStopIndex(ColumnProjectionSegment columnSegment) {
        if (columnSegment.getAliasSegment().isPresent()) {
            return ((AliasSegment)columnSegment.getAliasSegment().get()).getStopIndex();
        }
        return columnSegment.getColumn().getRightParentheses().isPresent() ? ((ParenthesesSegment)columnSegment.getColumn().getRightParentheses().get()).getStopIndex() : columnSegment.getColumn().getStopIndex();
    }

    private ColumnProjection buildColumnProjection(ColumnProjectionSegment segment) {
        IdentifierValue owner = segment.getColumn().getOwner().map(OwnerSegment::getIdentifier).orElse(null);
        return new ColumnProjection(owner, segment.getColumn().getIdentifier(), segment.getAliasName().isPresent() ? (IdentifierValue)segment.getAlias().orElse(null) : null, this.databaseType, (ParenthesesSegment)segment.getColumn().getLeftParentheses().orElse(null), (ParenthesesSegment)segment.getColumn().getRightParentheses().orElse(null), segment.getColumn().getColumnBoundInfo());
    }

    private Collection<Projection> generateProjections(EncryptColumn encryptColumn, ColumnProjection columnProjection, SubqueryType subqueryType, boolean newAddedColumn) {
        if (null == subqueryType || SubqueryType.PROJECTION == subqueryType) {
            return Collections.singleton(this.generateProjection(encryptColumn, columnProjection));
        }
        if (SubqueryType.TABLE == subqueryType || SubqueryType.JOIN == subqueryType || SubqueryType.WITH == subqueryType) {
            return this.generateProjectionsInTableSegmentSubquery(encryptColumn, columnProjection, newAddedColumn);
        }
        if (SubqueryType.PREDICATE == subqueryType) {
            return Collections.singleton(this.generateProjectionInPredicateSubquery(encryptColumn, columnProjection));
        }
        if (SubqueryType.INSERT_SELECT == subqueryType || SubqueryType.VIEW_DEFINITION == subqueryType) {
            return this.generateProjectionsInInsertSelectSubquery(encryptColumn, columnProjection);
        }
        throw new UnsupportedSQLOperationException("Projections not in simple select, table subquery, join subquery, predicate subquery and insert select subquery are not supported in encrypt feature.");
    }

    private ColumnProjection generateProjection(EncryptColumn encryptColumn, ColumnProjection columnProjection) {
        IdentifierValue cipherColumnName = new IdentifierValue(encryptColumn.getCipher().getName(), columnProjection.getName().getQuoteCharacter());
        return new ColumnProjection((IdentifierValue)columnProjection.getOwner().orElse(null), cipherColumnName, columnProjection.getAlias().orElse(columnProjection.getName()), this.databaseType, (ParenthesesSegment)columnProjection.getLeftParentheses().orElse(null), (ParenthesesSegment)columnProjection.getRightParentheses().orElse(null));
    }

    private Collection<Projection> generateProjectionsInTableSegmentSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection, boolean newAddedColumn) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        QuoteCharacter quoteCharacter = columnProjection.getName().getQuoteCharacter();
        IdentifierValue alias = columnProjection.getAlias().orElse(columnProjection.getName());
        IdentifierValue cipherColumnName = new IdentifierValue(encryptColumn.getCipher().getName(), quoteCharacter);
        ParenthesesSegment leftParentheses = columnProjection.getLeftParentheses().orElse(null);
        ParenthesesSegment rightParentheses = columnProjection.getRightParentheses().orElse(null);
        result.add((Projection)new ColumnProjection((IdentifierValue)columnProjection.getOwner().orElse(null), cipherColumnName, alias, this.databaseType, leftParentheses, rightParentheses));
        if (newAddedColumn) {
            result.add((Projection)new ColumnProjection((IdentifierValue)columnProjection.getOwner().orElse(null), cipherColumnName, null, this.databaseType));
            IdentifierValue assistedColumOwner = columnProjection.getOwner().orElse(null);
            encryptColumn.getAssistedQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(assistedColumOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)));
            encryptColumn.getLikeQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(assistedColumOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)));
        }
        return result;
    }

    private ColumnProjection generateProjectionInPredicateSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection) {
        QuoteCharacter quoteCharacter = columnProjection.getName().getQuoteCharacter();
        ParenthesesSegment leftParentheses = columnProjection.getLeftParentheses().orElse(null);
        ParenthesesSegment rightParentheses = columnProjection.getRightParentheses().orElse(null);
        IdentifierValue owner = columnProjection.getOwner().orElse(null);
        return encryptColumn.getAssistedQuery().map(optional -> new ColumnProjection(owner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)).orElseGet(() -> new ColumnProjection(owner, new IdentifierValue(encryptColumn.getCipher().getName(), quoteCharacter), columnProjection.getAlias().orElse(columnProjection.getName()), this.databaseType, leftParentheses, rightParentheses));
    }

    private Collection<Projection> generateProjectionsInInsertSelectSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection) {
        QuoteCharacter quoteCharacter = columnProjection.getName().getQuoteCharacter();
        IdentifierValue columnName = new IdentifierValue(encryptColumn.getCipher().getName(), quoteCharacter);
        LinkedList<Projection> result = new LinkedList<Projection>();
        ParenthesesSegment leftParentheses = columnProjection.getLeftParentheses().orElse(null);
        ParenthesesSegment rightParentheses = columnProjection.getRightParentheses().orElse(null);
        result.add((Projection)new ColumnProjection((IdentifierValue)columnProjection.getOwner().orElse(null), columnName, null, this.databaseType, leftParentheses, rightParentheses));
        IdentifierValue columOwner = columnProjection.getOwner().orElse(null);
        encryptColumn.getAssistedQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(columOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)));
        encryptColumn.getLikeQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(columOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)));
        return result;
    }

    private ShorthandProjection getShorthandProjection(ShorthandProjectionSegment segment, ProjectionsContext projectionsContext) {
        Optional owner = segment.getOwner().isPresent() ? Optional.of(((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue()) : Optional.empty();
        for (Projection each : projectionsContext.getProjections()) {
            if (!(each instanceof ShorthandProjection)) continue;
            if (!owner.isPresent() && !((ShorthandProjection)each).getOwner().isPresent()) {
                return (ShorthandProjection)each;
            }
            if (!owner.isPresent() || !((String)owner.get()).equals(((ShorthandProjection)each).getOwner().map(IdentifierValue::getValue).orElse(null))) continue;
            return (ShorthandProjection)each;
        }
        throw new IllegalStateException(String.format("Can not find shorthand projection segment, owner is `%s`", owner.orElse(null)));
    }

    @Generated
    public EncryptProjectionTokenGenerator(List<SQLToken> previousSQLTokens, EncryptRule rule, DatabaseType databaseType) {
        this.previousSQLTokens = previousSQLTokens;
        this.rule = rule;
        this.databaseType = databaseType;
    }
}

