/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.datasource;

import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client.MySQLServerVersion;
import org.apache.shardingsphere.data.pipeline.spi.JdbcQueryPropertiesExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLJdbcQueryPropertiesExtension
implements JdbcQueryPropertiesExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLJdbcQueryPropertiesExtension.class);
    private static final String MYSQL_CONNECTOR_VERSION = MySQLJdbcQueryPropertiesExtension.initMySQLConnectorVersion();
    private final Properties toBeOverrideQueryProps = new Properties();
    private final Properties completeIfMissedQueryProps = new Properties();

    public MySQLJdbcQueryPropertiesExtension() {
        this.toBeOverrideQueryProps.setProperty("useSSL", Boolean.FALSE.toString());
        this.toBeOverrideQueryProps.setProperty("useServerPrepStmts", Boolean.FALSE.toString());
        this.toBeOverrideQueryProps.setProperty("rewriteBatchedStatements", Boolean.TRUE.toString());
        this.toBeOverrideQueryProps.setProperty("yearIsDateType", Boolean.FALSE.toString());
        this.toBeOverrideQueryProps.setProperty("zeroDateTimeBehavior", this.getZeroDateTimeBehavior());
        this.toBeOverrideQueryProps.setProperty("noDatetimeStringSync", Boolean.TRUE.toString());
        this.toBeOverrideQueryProps.setProperty("jdbcCompliantTruncation", Boolean.FALSE.toString());
        this.completeIfMissedQueryProps.setProperty("netTimeoutForStreamingResults", "600");
    }

    private String getZeroDateTimeBehavior() {
        return null != MYSQL_CONNECTOR_VERSION && new MySQLServerVersion(MYSQL_CONNECTOR_VERSION).greaterThanOrEqualTo(8, 0, 0) ? "CONVERT_TO_NULL" : "convertToNull";
    }

    private static String initMySQLConnectorVersion() {
        try {
            Class<?> driverClass = Thread.currentThread().getContextClassLoader().loadClass("com.mysql.jdbc.Driver");
            return driverClass.getPackage().getImplementationVersion();
        }
        catch (ClassNotFoundException ex) {
            log.warn("Can not find `com.mysql.jdbc.Driver` class.");
            return null;
        }
    }

    public void extendQueryProperties(Properties props) {
        for (String each : this.toBeOverrideQueryProps.stringPropertyNames()) {
            props.setProperty(each, this.toBeOverrideQueryProps.getProperty(each));
        }
        for (String each : this.completeIfMissedQueryProps.stringPropertyNames()) {
            if (props.containsKey(each)) continue;
            props.setProperty(each, this.completeIfMissedQueryProps.getProperty(each));
        }
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

