/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.constraints;

import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.PostgreSQLDDLTemplateExecutor;

public final class PostgreSQLConstraintsPropertiesAppender {
    private static final Integer PG_CONSTRAINTS_INCLUDE_VERSION = 11;
    private final PostgreSQLDDLTemplateExecutor templateExecutor;

    public PostgreSQLConstraintsPropertiesAppender(Connection connection, int majorVersion, int minorVersion) {
        this.templateExecutor = new PostgreSQLDDLTemplateExecutor(connection, majorVersion, minorVersion);
    }

    public void append(Map<String, Object> context) {
        this.loadPrimaryOrUniqueConstraint(context, "primary_key", "p");
        this.loadPrimaryOrUniqueConstraint(context, "unique_constraint", "u");
        context.put("foreign_key", this.fetchForeignKeys(context));
        context.put("check_constraint", this.fetchCheckConstraints(context));
        context.put("exclude_constraint", this.getExclusionConstraints(context));
    }

    private Collection<Map<String, Object>> fetchCheckConstraints(Map<String, Object> context) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        for (Map<String, Object> each : this.getCheckConstraints((Long)context.get("tid"))) {
            if (this.isPartitionAndConstraintInherited(each, context)) continue;
            result.add(each);
        }
        return result;
    }

    private Collection<Map<String, Object>> fetchForeignKeys(Map<String, Object> context) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        for (Map<String, Object> each : this.getForeignKeys((Long)context.get("tid"))) {
            if (this.isPartitionAndConstraintInherited(each, context)) continue;
            result.add(each);
        }
        return result;
    }

    private void loadPrimaryOrUniqueConstraint(Map<String, Object> context, String name, String type) {
        Collection<Map<String, Object>> constraintsProps = this.fetchConstraintsProperties(context, type);
        this.fetchConstraintsColumns(constraintsProps);
        context.put(name, constraintsProps.stream().filter(each -> !this.isPartitionAndConstraintInherited((Map<String, Object>)each, context)).collect(Collectors.toList()));
    }

    private void fetchConstraintsColumns(Collection<Map<String, Object>> constraintsProps) {
        for (Map<String, Object> each : constraintsProps) {
            LinkedList columns = new LinkedList();
            for (Map<String, Object> col : this.fetchConstraintsCols(each)) {
                HashMap<String, String> column = new HashMap<String, String>();
                column.put("column", this.stripQuote((String)col.get("column")));
                columns.add(column);
            }
            each.put("columns", columns);
            this.appendConstraintsInclude(each);
        }
    }

    private void appendConstraintsInclude(Map<String, Object> constraintsProp) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("cid", constraintsProp.get("oid"));
        LinkedList<Object> includes = new LinkedList<Object>();
        if (this.templateExecutor.getMajorVersion() >= PG_CONSTRAINTS_INCLUDE_VERSION) {
            for (Map<String, Object> each : this.templateExecutor.executeByTemplate(params, "component/index_constraint/%s/get_constraint_include.ftl")) {
                includes.add(each.get("colname"));
            }
        }
        constraintsProp.put("include", includes);
    }

    private String stripQuote(String column) {
        String result = column;
        if (column.startsWith("\"")) {
            result = result.substring(1);
        }
        if (column.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private Collection<Map<String, Object>> fetchConstraintsCols(Map<String, Object> constraintColProps) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", constraintColProps.get("oid"));
        params.put("colcnt", constraintColProps.get("col_count"));
        return this.templateExecutor.executeByTemplate(params, "component/index_constraint/%s/get_costraint_cols.ftl");
    }

    private Collection<Map<String, Object>> fetchConstraintsProperties(Map<String, Object> context, String constraintType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("did", context.get("did"));
        params.put("tid", context.get("tid"));
        params.put("cid", context.get("cid"));
        params.put("constraint_type", constraintType);
        return this.templateExecutor.executeByTemplate(params, "component/index_constraint/%s/properties.ftl");
    }

    private Collection<Map<String, Object>> getExclusionConstraints(Map<String, Object> context) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tid", context.get("tid"));
        params.put("did", context.get("did"));
        Collection<Map<String, Object>> result = this.templateExecutor.executeByTemplate(params, "component/exclusion_constraint/%s/properties.ftl");
        for (Map<String, Object> each : result) {
            this.getExclusionConstraintsColumns(each);
        }
        return result;
    }

    private void getExclusionConstraintsColumns(Map<String, Object> exclusionConstraintsProps) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", exclusionConstraintsProps.get("oid"));
        params.put("col_count", exclusionConstraintsProps.get("col_count"));
        LinkedList columns = new LinkedList();
        for (Map<String, Object> each : this.templateExecutor.executeByTemplate(params, "component/exclusion_constraint/%s/get_constraint_cols.ftl")) {
            boolean order = 0 == ((Integer)each.get("options") & 1);
            boolean nullsOrder = 0 != ((Integer)each.get("options") & 2);
            HashMap<String, Object> col = new HashMap<String, Object>();
            col.put("column", this.strip((String)each.get("coldef")));
            col.put("oper_class", each.get("opcname"));
            col.put("order", order);
            col.put("nulls_order", nullsOrder);
            col.put("operator", each.get("oprname"));
            col.put("col_type", each.get("datatype"));
            col.put("is_exp", each.get("is_exp"));
            columns.add(col);
        }
        exclusionConstraintsProps.put("columns", columns);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cid", exclusionConstraintsProps.get("oid"));
        LinkedList<String> include = new LinkedList<String>();
        if (this.templateExecutor.getMajorVersion() >= PG_CONSTRAINTS_INCLUDE_VERSION) {
            for (Map<String, Object> each : this.templateExecutor.executeByTemplate(map, "exclusion_constraint/%s/get_constraint_include.ftl")) {
                include.add(each.get("colname").toString());
            }
        }
        exclusionConstraintsProps.put("include", include);
    }

    private Collection<Map<String, Object>> getForeignKeys(Long tid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tid", tid);
        Collection<Map<String, Object>> result = this.templateExecutor.executeByTemplate(params, "component/foreign_key/%s/properties.ftl");
        for (Map<String, Object> each : result) {
            LinkedList<Map<String, Object>> columns = new LinkedList<Map<String, Object>>();
            HashSet<String> cols = new HashSet<String>();
            for (Map<String, Object> col : this.getForeignKeysCols(tid, each)) {
                HashMap<String, Object> foreignKeysRef = new HashMap<String, Object>();
                foreignKeysRef.put("local_column", col.get("conattname"));
                foreignKeysRef.put("references", each.get("confrelid"));
                foreignKeysRef.put("referenced", col.get("confattname"));
                foreignKeysRef.put("references_table_name", each.get("refnsp") + "." + each.get("reftab"));
                columns.add(foreignKeysRef);
                cols.add((String)col.get("conattname"));
            }
            this.setRemoteName(each, columns);
            Optional<String> coveringindex = this.searchCoveringIndex(tid, cols);
            each.put("coveringindex", coveringindex.orElse(null));
            each.put("autoindex", !coveringindex.isPresent());
            each.put("hasindex", coveringindex.isPresent());
            each.put("columns", columns);
        }
        return result;
    }

    private void setRemoteName(Map<String, Object> foreignKey, Collection<Map<String, Object>> columns) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tid", columns.iterator().next().get("references"));
        Map<String, Object> parents = this.templateExecutor.executeByTemplateForSingleRow(params, "component/foreign_key/%s/get_parent.ftl");
        foreignKey.put("remote_schema", parents.get("schema"));
        foreignKey.put("remote_table", parents.get("table"));
    }

    private Collection<Map<String, Object>> getForeignKeysCols(Long tid, Map<String, Object> foreignKeyProps) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tid", tid);
        LinkedList keys = new LinkedList();
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("confkey", foreignKeyProps.get("confkey"));
        key.put("conkey", foreignKeyProps.get("conkey"));
        keys.add(key);
        params.put("keys", keys);
        return this.templateExecutor.executeByTemplate(params, "component/foreign_key/%s/get_constraint_cols.ftl");
    }

    private boolean isPartitionAndConstraintInherited(Map<String, Object> constraint, Map<String, Object> context) {
        return context.containsKey("relispartition") && (Boolean)context.get("relispartition") != false && constraint.containsKey("conislocal") && (Boolean)constraint.get("conislocal") != false;
    }

    private Optional<String> searchCoveringIndex(Long tid, Set<String> cols) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tid", tid);
        for (Map<String, Object> each : this.templateExecutor.executeByTemplate(params, "component/foreign_key/%s/get_constraints.ftl")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("cid", each.get("oid"));
            map.put("colcnt", each.get("col_count"));
            Collection<Map<String, Object>> rows = this.templateExecutor.executeByTemplate(map, "component/foreign_key/%s/get_cols.ftl");
            HashSet<String> indexCols = new HashSet<String>();
            for (Map<String, Object> row : rows) {
                indexCols.add(this.strip(row.get("column").toString()));
            }
            if (!this.isSame(indexCols, cols)) continue;
            return Optional.of((String)each.get("idxname"));
        }
        return Optional.empty();
    }

    private boolean isSame(Set<String> indexCols, Set<String> cols) {
        HashSet<String> copyIndexCols = new HashSet<String>(indexCols);
        HashSet<String> copyCols = new HashSet<String>(cols);
        copyIndexCols.removeAll(copyCols);
        if (copyIndexCols.isEmpty()) {
            cols.removeAll(indexCols);
            return cols.isEmpty();
        }
        return false;
    }

    private String strip(String column) {
        if (column.startsWith("\"")) {
            return column.substring(1);
        }
        if (column.endsWith("\"")) {
            return column.substring(0, column.length() - 1);
        }
        return column;
    }

    private Collection<Map<String, Object>> getCheckConstraints(Long tid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tid", tid);
        return this.templateExecutor.executeByTemplate(params, "component/check_constraint/%s/properties.ftl");
    }
}

