/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.executor.rdl.resource;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.resource.StorageUnitDefinitionProcessor;
import org.apache.shardingsphere.distsql.statement.rdl.resource.unit.type.UnregisterStorageUnitStatement;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.server.ShardingSphereServerException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.InUsedStorageUnitException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.StorageUnitsOperateException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnregisterStorageUnitExecutor
implements DistSQLUpdateExecutor<UnregisterStorageUnitStatement>,
DistSQLExecutorDatabaseAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnregisterStorageUnitExecutor.class);
    private ShardingSphereDatabase database;

    @Override
    public void executeUpdate(UnregisterStorageUnitStatement sqlStatement, ContextManager contextManager) {
        if (!sqlStatement.isIfExists()) {
            this.checkExisted(sqlStatement.getStorageUnitNames());
        }
        this.checkInUsed(sqlStatement);
        try {
            contextManager.getPersistServiceFacade().getMetaDataManagerPersistService().unregisterStorageUnits(this.database.getName(), sqlStatement.getStorageUnitNames());
        }
        catch (SQLException | ShardingSphereServerException ex) {
            throw new StorageUnitsOperateException("unregister", sqlStatement.getStorageUnitNames(), (Exception)ex);
        }
    }

    private void checkExisted(Collection<String> storageUnitNames) {
        Map storageUnits = this.database.getResourceMetaData().getStorageUnits();
        Collection notExistedStorageUnits = storageUnitNames.stream().filter(each -> !storageUnits.containsKey(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedStorageUnits, () -> new MissingRequiredStorageUnitsException(this.database.getName(), notExistedStorageUnits));
    }

    private void checkInUsed(UnregisterStorageUnitStatement sqlStatement) {
        Map inUsedStorageUnits = this.database.getRuleMetaData().getInUsedStorageUnitNameAndRulesMap();
        Set inUsedStorageUnitNames = inUsedStorageUnits.keySet();
        inUsedStorageUnitNames.retainAll(sqlStatement.getStorageUnitNames());
        if (inUsedStorageUnitNames.isEmpty()) {
            return;
        }
        Collection<Class<ShardingSphereRule>> ignoreUsageCheckRules = this.getIgnoreUsageCheckRules(sqlStatement);
        String firstResource = (String)inUsedStorageUnitNames.iterator().next();
        ShardingSpherePreconditions.checkNotEmpty(ignoreUsageCheckRules, () -> new InUsedStorageUnitException(firstResource, (Collection)inUsedStorageUnits.get(firstResource)));
        this.checkInUsedIgnoreTables(new HashSet<String>(inUsedStorageUnitNames), inUsedStorageUnits, ignoreUsageCheckRules);
    }

    private Collection<Class<ShardingSphereRule>> getIgnoreUsageCheckRules(UnregisterStorageUnitStatement sqlStatement) {
        LinkedList<Class<ShardingSphereRule>> result = new LinkedList<Class<ShardingSphereRule>>();
        for (StorageUnitDefinitionProcessor each : ShardingSphereServiceLoader.getServiceInstances(StorageUnitDefinitionProcessor.class)) {
            if (!each.ignoreUsageCheckOnUnregister(sqlStatement)) continue;
            result.add(each.getRuleClass());
        }
        return result;
    }

    private void checkInUsedIgnoreTables(Collection<String> inUsedResourceNames, Map<String, Collection<Class<? extends ShardingSphereRule>>> inUsedStorageUnits, Collection<Class<ShardingSphereRule>> ignoreShardingSphereRules) {
        for (String each : inUsedResourceNames) {
            Collection<Class<? extends ShardingSphereRule>> inUsedRules = inUsedStorageUnits.get(each);
            ignoreShardingSphereRules.forEach(inUsedRules::remove);
            ShardingSpherePreconditions.checkMustEmpty(inUsedRules, () -> new InUsedStorageUnitException(each, inUsedRules));
        }
    }

    @Override
    public Class<UnregisterStorageUnitStatement> getType() {
        return UnregisterStorageUnitStatement.class;
    }

    @Override
    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

