/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.executor.rql.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.handler.executor.rql.rule.CountResultRowBuilder;
import org.apache.shardingsphere.distsql.statement.rql.rule.database.CountRuleStatement;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class RuleCountExecutor
implements DistSQLQueryExecutor<CountRuleStatement>,
DistSQLExecutorDatabaseAware {
    private ShardingSphereDatabase database;

    @Override
    public Collection<String> getColumnNames(CountRuleStatement sqlStatement) {
        return Arrays.asList("rule_name", "database", "count");
    }

    @Override
    public Collection<LocalDataQueryResultRow> getRows(CountRuleStatement sqlStatement, ContextManager contextManager) {
        Optional rowBuilder = TypedSPILoader.findService(CountResultRowBuilder.class, (Object)sqlStatement.getType());
        if (!rowBuilder.isPresent()) {
            return Collections.emptyList();
        }
        Optional rule = this.database.getRuleMetaData().findSingleRule(((CountResultRowBuilder)rowBuilder.get()).getRuleClass());
        return rule.isPresent() ? ((CountResultRowBuilder)rowBuilder.get()).generateRows((ShardingSphereRule)rule.get(), this.database.getName()) : Collections.emptyList();
    }

    @Override
    public Class<CountRuleStatement> getType() {
        return CountRuleStatement.class;
    }

    @Override
    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

