/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command;

import io.netty.channel.ChannelHandlerContext;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.packet.command.CommandPacket;
import org.apache.shardingsphere.db.protocol.packet.command.CommandPacketType;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketFactory;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLDataRowPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLReadyForQueryPacket;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PortalContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLCommandExecutorFactory;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLPortalContextRegistry;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.PostgreSQLCommand;
import org.apache.shardingsphere.proxy.frontend.postgresql.err.PostgreSQLErrorPacketFactory;

public final class PostgreSQLCommandExecuteEngine
implements CommandExecuteEngine {
    public PostgreSQLCommandPacketType getCommandPacketType(PacketPayload payload) {
        return PostgreSQLCommandPacketType.valueOf((int)payload.getByteBuf().getByte(payload.getByteBuf().readerIndex()));
    }

    public PostgreSQLCommandPacket getCommandPacket(PacketPayload payload, CommandPacketType type, ConnectionSession connectionSession) {
        return PostgreSQLCommandPacketFactory.newInstance((PostgreSQLCommandPacketType)((PostgreSQLCommandPacketType)type), (PostgreSQLPacketPayload)((PostgreSQLPacketPayload)payload));
    }

    public CommandExecutor getCommandExecutor(CommandPacketType type, CommandPacket packet, ConnectionSession connectionSession) throws SQLException {
        PortalContext portalContext = PostgreSQLPortalContextRegistry.getInstance().get(connectionSession.getConnectionId());
        return PostgreSQLCommandExecutorFactory.newInstance((PostgreSQLCommandPacketType)type, (PostgreSQLCommandPacket)packet, connectionSession, portalContext);
    }

    public PostgreSQLPacket getErrorPacket(Exception cause) {
        return PostgreSQLErrorPacketFactory.newInstance(cause);
    }

    public Optional<DatabasePacket> getOtherPacket(ConnectionSession connectionSession) {
        return Optional.of(connectionSession.getTransactionStatus().isInTransaction() ? PostgreSQLReadyForQueryPacket.TRANSACTION_FAILED : PostgreSQLReadyForQueryPacket.NOT_IN_TRANSACTION);
    }

    public void writeQueryData(ChannelHandlerContext context, ProxyDatabaseConnectionManager databaseConnectionManager, QueryCommandExecutor queryCommandExecutor, int headerPackagesCount) throws SQLException {
        if (ResponseType.QUERY == queryCommandExecutor.getResponseType() && !context.channel().isActive()) {
            context.write((Object)new PostgreSQLCommandCompletePacket(PostgreSQLCommand.SELECT.name(), 0L));
            return;
        }
        this.processSimpleQuery(context, databaseConnectionManager, queryCommandExecutor);
    }

    private void processSimpleQuery(ChannelHandlerContext context, ProxyDatabaseConnectionManager databaseConnectionManager, QueryCommandExecutor queryExecutor) throws SQLException {
        if (ResponseType.UPDATE == queryExecutor.getResponseType()) {
            context.write((Object)(databaseConnectionManager.getConnectionSession().getTransactionStatus().isInTransaction() ? PostgreSQLReadyForQueryPacket.IN_TRANSACTION : PostgreSQLReadyForQueryPacket.NOT_IN_TRANSACTION));
            return;
        }
        long dataRows = this.writeDataPackets(context, databaseConnectionManager, queryExecutor);
        if (ResponseType.QUERY == queryExecutor.getResponseType()) {
            context.write((Object)new PostgreSQLCommandCompletePacket(PostgreSQLCommand.SELECT.name(), dataRows));
        }
        context.write((Object)(databaseConnectionManager.getConnectionSession().getTransactionStatus().isInTransaction() ? PostgreSQLReadyForQueryPacket.IN_TRANSACTION : PostgreSQLReadyForQueryPacket.NOT_IN_TRANSACTION));
    }

    private long writeDataPackets(ChannelHandlerContext context, ProxyDatabaseConnectionManager databaseConnectionManager, QueryCommandExecutor queryCommandExecutor) throws SQLException {
        long dataRows = 0L;
        int flushCount = 0;
        int proxyFrontendFlushThreshold = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_FLUSH_THRESHOLD);
        while (queryCommandExecutor.next()) {
            databaseConnectionManager.getConnectionResourceLock().doAwait(context);
            DatabasePacket resultValue = queryCommandExecutor.getQueryRowPacket();
            context.write((Object)resultValue);
            if (proxyFrontendFlushThreshold == ++flushCount) {
                context.flush();
                flushCount = 0;
            }
            if (!(resultValue instanceof PostgreSQLDataRowPacket)) continue;
            ++dataRows;
        }
        return dataRows;
    }
}

