/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.connection.kernel;

import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLCheckEngine;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContextBuilder;
import org.apache.shardingsphere.infra.executor.sql.log.SQLLogger;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rewrite.SQLRewriteEntry;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteResult;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.engine.SQLRouteEngine;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class KernelProcessor {
    public ExecutionContext generateExecutionContext(QueryContext queryContext, RuleMetaData globalRuleMetaData, ConfigurationProperties props) {
        this.check(queryContext);
        RouteContext routeContext = this.route(queryContext, globalRuleMetaData, props);
        SQLRewriteResult rewriteResult = this.rewrite(queryContext, globalRuleMetaData, props, routeContext);
        ExecutionContext result = this.createExecutionContext(queryContext, routeContext, rewriteResult);
        this.logSQL(queryContext, props, result);
        return result;
    }

    private void check(QueryContext queryContext) {
        if (queryContext.getHintValueContext().isSkipMetadataValidate()) {
            return;
        }
        ShardingSphereDatabase database = queryContext.getUsedDatabase();
        new SupportedSQLCheckEngine().checkSQL(database.getRuleMetaData().getRules(), queryContext.getSqlStatementContext(), database);
    }

    private RouteContext route(QueryContext queryContext, RuleMetaData globalRuleMetaData, ConfigurationProperties props) {
        ShardingSphereDatabase database = queryContext.getUsedDatabase();
        return new SQLRouteEngine(database.getRuleMetaData().getRules(), props).route(queryContext, globalRuleMetaData, database);
    }

    private SQLRewriteResult rewrite(QueryContext queryContext, RuleMetaData globalRuleMetaData, ConfigurationProperties props, RouteContext routeContext) {
        SQLRewriteEntry sqlRewriteEntry = new SQLRewriteEntry(queryContext.getUsedDatabase(), globalRuleMetaData, props);
        return sqlRewriteEntry.rewrite(queryContext, routeContext);
    }

    private ExecutionContext createExecutionContext(QueryContext queryContext, RouteContext routeContext, SQLRewriteResult rewriteResult) {
        return new ExecutionContext(queryContext, ExecutionContextBuilder.build((ShardingSphereDatabase)queryContext.getUsedDatabase(), (SQLRewriteResult)rewriteResult, (SQLStatementContext)queryContext.getSqlStatementContext()), routeContext);
    }

    private void logSQL(QueryContext queryContext, ConfigurationProperties props, ExecutionContext executionContext) {
        if (((Boolean)props.getValue((Enum)ConfigurationPropertyKey.SQL_SHOW)).booleanValue()) {
            SQLLogger.logSQL((QueryContext)queryContext, (boolean)((Boolean)props.getValue((Enum)ConfigurationPropertyKey.SQL_SIMPLE)), (ExecutionContext)executionContext);
        }
    }
}

