/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource.unit;

import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datasource.pool.CatalogSwitchableDataSource;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;

public final class StorageUnit {
    private final StorageNode storageNode;
    private final DatabaseType storageType;
    private final DataSource dataSource;
    private final DataSourcePoolProperties dataSourcePoolProperties;
    private final ConnectionProperties connectionProperties;

    public StorageUnit(StorageNode storageNode, DataSourcePoolProperties dataSourcePoolProps, DataSource dataSource) {
        this.storageNode = storageNode;
        Map standardProps = dataSourcePoolProps.getConnectionPropertySynonyms().getStandardProperties();
        String url = standardProps.get("url").toString();
        Object originUsername = standardProps.get("username");
        String username = null != originUsername ? originUsername.toString() : "";
        this.storageType = DatabaseTypeFactory.get((String)url);
        boolean isInstanceConnectionAvailable = new DatabaseTypeRegistry(this.storageType).getDialectDatabaseMetaData().isInstanceConnectionAvailable();
        String catalog = isInstanceConnectionAvailable ? ((ConnectionPropertiesParser)DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, (DatabaseType)this.storageType)).parse(url, username, null).getCatalog() : null;
        this.dataSource = isInstanceConnectionAvailable ? new CatalogSwitchableDataSource(dataSource, catalog, url) : dataSource;
        this.dataSourcePoolProperties = dataSourcePoolProps;
        this.connectionProperties = this.createConnectionProperties(catalog, standardProps);
    }

    private ConnectionProperties createConnectionProperties(String catalog, Map<String, Object> standardProps) {
        ConnectionPropertiesParser parser = (ConnectionPropertiesParser)DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, (DatabaseType)this.storageType);
        return parser.parse(standardProps.get("url").toString(), standardProps.getOrDefault("username", "").toString(), catalog);
    }

    @Generated
    public StorageNode getStorageNode() {
        return this.storageNode;
    }

    @Generated
    public DatabaseType getStorageType() {
        return this.storageType;
    }

    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public DataSourcePoolProperties getDataSourcePoolProperties() {
        return this.dataSourcePoolProperties;
    }

    @Generated
    public ConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }
}

