/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata.data.dialect.type;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.sharding.metadata.data.dialect.DialectShardingStatisticsTableCollector;

public final class OpenGaussShardingStatisticsTableCollector
implements DialectShardingStatisticsTableCollector {
    private static final String FETCH_TABLE_ROWS_AND_DATA_LENGTH_SQL = "SELECT RELTUPLES AS TABLE_ROWS, PG_TABLE_SIZE(?) AS DATA_LENGTH FROM PG_CLASS WHERE RELNAME = ?";

    @Override
    public boolean appendRow(Connection connection, DataNode dataNode, List<Object> row) throws SQLException {
        if (!this.isTableExist(connection, dataNode.getTableName())) {
            return false;
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(FETCH_TABLE_ROWS_AND_DATA_LENGTH_SQL);){
            preparedStatement.setString(1, dataNode.getTableName());
            preparedStatement.setString(2, dataNode.getTableName());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    row.add(resultSet.getBigDecimal("TABLE_ROWS"));
                    row.add(resultSet.getBigDecimal("DATA_LENGTH"));
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private boolean isTableExist(Connection connection, String tableNamePattern) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), tableNamePattern, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    public String getDatabaseType() {
        return "openGauss";
    }
}

