/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.changed;

import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropRuleItem;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class DefaultShardingColumnChangedProcessor
implements RuleItemConfigurationChangedProcessor<ShardingRuleConfiguration, String> {
    public String swapRuleItemConfiguration(AlterRuleItem alterRuleItem, String yamlContent) {
        return yamlContent;
    }

    public ShardingRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ShardingRule.class).map(ShardingRule::getConfiguration).orElseGet(ShardingRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(AlterRuleItem alterRuleItem, ShardingRuleConfiguration currentRuleConfig, String toBeChangedItemConfig) {
        currentRuleConfig.setDefaultShardingColumn(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItem dropRuleItem, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.setDefaultShardingColumn(null);
    }

    public String getType() {
        return "sharding.default_sharding_column";
    }
}

