/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.batch.preparedstatement;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;

public final class BatchExecutionUnit {
    private final ExecutionUnit executionUnit;
    private final Map<Integer, Integer> jdbcAndActualAddBatchCallTimesMap = new LinkedHashMap<Integer, Integer>();
    private int actualCallAddBatchTimes;

    public void mapAddBatchCount(int jdbcAddBatchTimes) {
        this.jdbcAndActualAddBatchCallTimesMap.put(jdbcAddBatchTimes, this.actualCallAddBatchTimes++);
    }

    public List<List<Object>> getParameterSets() {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        if (this.executionUnit.getSqlUnit().getParameters().isEmpty() || 0 == this.actualCallAddBatchTimes) {
            result.add(Collections.emptyList());
        } else {
            result.addAll(Lists.partition((List)this.executionUnit.getSqlUnit().getParameters(), (int)(this.executionUnit.getSqlUnit().getParameters().size() / this.actualCallAddBatchTimes)));
        }
        return result;
    }

    @Generated
    public BatchExecutionUnit(ExecutionUnit executionUnit) {
        this.executionUnit = executionUnit;
    }

    @Generated
    public ExecutionUnit getExecutionUnit() {
        return this.executionUnit;
    }

    @Generated
    public Map<Integer, Integer> getJdbcAndActualAddBatchCallTimesMap() {
        return this.jdbcAndActualAddBatchCallTimesMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchExecutionUnit)) {
            return false;
        }
        BatchExecutionUnit other = (BatchExecutionUnit)o;
        ExecutionUnit this$executionUnit = this.getExecutionUnit();
        ExecutionUnit other$executionUnit = other.getExecutionUnit();
        return !(this$executionUnit == null ? other$executionUnit != null : !this$executionUnit.equals(other$executionUnit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExecutionUnit $executionUnit = this.getExecutionUnit();
        result = result * 59 + ($executionUnit == null ? 43 : $executionUnit.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BatchExecutionUnit(executionUnit=" + this.getExecutionUnit() + ", jdbcAndActualAddBatchCallTimesMap=" + this.getJdbcAndActualAddBatchCallTimesMap() + ", actualCallAddBatchTimes=" + this.actualCallAddBatchTimes + ")";
    }
}

