/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.server;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodePath;

public final class ServerNode {
    public static final String ROOT = "servers";
    private static final String SERVERS = "servers/%s";
    private final String jobName;
    private final JobNodePath jobNodePath;

    public ServerNode(String jobName) {
        this.jobName = jobName;
        this.jobNodePath = new JobNodePath(jobName);
    }

    public boolean isServerPath(String path) {
        return Pattern.compile(this.jobNodePath.getFullPath(ROOT) + "/" + "((\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)){3})").matcher(path).matches();
    }

    public boolean isLocalServerPath(String path) {
        JobInstance jobInstance = JobRegistry.getInstance().getJobInstance(this.jobName);
        if (Objects.isNull(jobInstance)) {
            return false;
        }
        return path.equals(this.jobNodePath.getFullPath(String.format(SERVERS, jobInstance.getServerIp())));
    }

    String getServerNode(String ip) {
        return String.format(SERVERS, ip);
    }
}

