/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.oracle.connector;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.database.core.connector.StandardConnectionProperties;
import org.apache.shardingsphere.infra.database.core.exception.UnrecognizedDatabaseURLException;

public final class OracleConnectionPropertiesParser
implements ConnectionPropertiesParser {
    private static final int DEFAULT_PORT = 1521;
    private static final int THIN_MATCH_GROUP_COUNT = 5;
    private static final Pattern THIN_URL_PATTERN = Pattern.compile("jdbc:oracle:(thin|oci|kprb):@(//)?([\\w\\-\\.]+):?(\\d*)[:/]([\\w\\-]+)", 2);
    private static final Pattern CONNECT_DESCRIPTOR_URL_PATTERN = Pattern.compile("jdbc:oracle:(thin|oci|kprb):@[(\\w\\s=)]+HOST\\s*=\\s*([\\w\\-\\.]+).*PORT\\s*=\\s*(\\d+).*SERVICE_NAME\\s*=\\s*(\\w+)\\)");

    public ConnectionProperties parse(String url, String username, String catalog) {
        List<Matcher> matchers = Arrays.asList(THIN_URL_PATTERN.matcher(url), CONNECT_DESCRIPTOR_URL_PATTERN.matcher(url));
        Matcher matcher = matchers.stream().filter(Matcher::find).findAny().orElseThrow(() -> new UnrecognizedDatabaseURLException(url, THIN_URL_PATTERN.pattern()));
        int groupCount = matcher.groupCount();
        return 5 == groupCount ? this.getThinConnectionProperties(username, matcher) : this.getStandardConnectionProperties(username, matcher);
    }

    private StandardConnectionProperties getThinConnectionProperties(String username, Matcher matcher) {
        return new StandardConnectionProperties(matcher.group(3), Strings.isNullOrEmpty((String)matcher.group(4)) ? 1521 : Integer.parseInt(matcher.group(4)), matcher.group(5), username);
    }

    private StandardConnectionProperties getStandardConnectionProperties(String username, Matcher matcher) {
        return new StandardConnectionProperties(matcher.group(2), Strings.isNullOrEmpty((String)matcher.group(3)) ? 1521 : Integer.parseInt(matcher.group(3)), matcher.group(4), username);
    }

    public String getDatabaseType() {
        return "Oracle";
    }
}

