/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.metadata;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class DataSourceMetaDataNodePath {
    private static final String ROOT_NODE = "/metadata";
    private static final String DATA_SOURCES_NODE = "data_sources";
    private static final String NODES_NODE = "nodes";
    private static final String UNITS_NODE = "units";
    private static final String VERSIONS_NODE = "versions";
    private static final String ACTIVE_VERSION_NODE = "active_version";
    private static final String IDENTIFIER_PATTERN = "([\\w\\-]+)";

    public static String getDataSourceRootPath(String databaseName) {
        return String.join((CharSequence)"/", ROOT_NODE, databaseName, DATA_SOURCES_NODE);
    }

    public static String getStorageUnitsPath(String databaseName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNodePath.getDataSourceRootPath(databaseName), UNITS_NODE);
    }

    public static String getStorageNodesPath(String databaseName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNodePath.getDataSourceRootPath(databaseName), NODES_NODE);
    }

    public static String getStorageUnitPath(String databaseName, String storageUnitName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNodePath.getStorageUnitsPath(databaseName), storageUnitName);
    }

    public static String getStorageNodePath(String databaseName, String storageNodeName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNodePath.getStorageNodesPath(databaseName), storageNodeName);
    }

    public static String getStorageUnitVersionPath(String databaseName, String storageUnitName, String version) {
        return String.join((CharSequence)"/", DataSourceMetaDataNodePath.getStorageUnitVersionsPath(databaseName, storageUnitName), version);
    }

    public static String getStorageUnitVersionsPath(String databaseName, String dataSourceName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNodePath.getStorageUnitsPath(databaseName), dataSourceName, VERSIONS_NODE);
    }

    public static String getStorageUnitActiveVersionPath(String databaseName, String dataSourceName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNodePath.getStorageUnitsPath(databaseName), dataSourceName, ACTIVE_VERSION_NODE);
    }

    public static String getStorageNodeVersionsPath(String databaseName, String storageNodeName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNodePath.getStorageNodesPath(databaseName), storageNodeName, VERSIONS_NODE);
    }

    public static String getStorageNodeVersionPath(String databaseName, String storageNodeName, String version) {
        return String.join((CharSequence)"/", DataSourceMetaDataNodePath.getStorageNodeVersionsPath(databaseName, storageNodeName), version);
    }

    public static String getStorageNodeActiveVersionPath(String databaseName, String storageNodeName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNodePath.getStorageNodesPath(databaseName), storageNodeName, ACTIVE_VERSION_NODE);
    }

    public static Optional<String> findStorageUnitNameByActiveVersionPath(String path) {
        Pattern pattern = Pattern.compile(DataSourceMetaDataNodePath.getStorageUnitActiveVersionPath(IDENTIFIER_PATTERN, IDENTIFIER_PATTERN), 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> findStorageUnitNameByStorageUnitPath(String path) {
        Pattern pattern = Pattern.compile(DataSourceMetaDataNodePath.getStorageUnitPath(IDENTIFIER_PATTERN, IDENTIFIER_PATTERN) + "$", 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> findStorageNodeNameByActiveVersionPath(String path) {
        Pattern pattern = Pattern.compile(DataSourceMetaDataNodePath.getStorageNodeActiveVersionPath(IDENTIFIER_PATTERN, IDENTIFIER_PATTERN), 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> findStorageNodeNameByStorageNodePath(String path) {
        Pattern pattern = Pattern.compile(DataSourceMetaDataNodePath.getStorageNodePath(IDENTIFIER_PATTERN, IDENTIFIER_PATTERN) + "$", 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static boolean isDataSourceRootPath(String path) {
        return Pattern.compile(DataSourceMetaDataNodePath.getDataSourceRootPath(IDENTIFIER_PATTERN) + "?", 2).matcher(path).find();
    }

    @Generated
    private DataSourceMetaDataNodePath() {
    }
}

