/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.statement.DropShardingTableReferenceRuleStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

@DistSQLExecutorCurrentRuleRequired(value=ShardingRule.class)
public final class DropShardingTableReferenceExecutor
implements DatabaseRuleDropExecutor<DropShardingTableReferenceRuleStatement, ShardingRule, ShardingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShardingRule rule;

    public void checkBeforeUpdate(DropShardingTableReferenceRuleStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkCurrentRuleConfiguration();
            this.checkToBeDroppedShardingTableReferenceRules(sqlStatement);
        }
    }

    private void checkCurrentRuleConfiguration() {
        ShardingSpherePreconditions.checkNotEmpty((Collection)this.rule.getConfiguration().getBindingTableGroups(), () -> new MissingRequiredRuleException("Sharding table reference", this.database.getName()));
    }

    private void checkToBeDroppedShardingTableReferenceRules(DropShardingTableReferenceRuleStatement sqlStatement) {
        Collection<String> currentRuleNames = this.getCurrentShardingTableReferenceRuleNames();
        Collection notExistedRuleNames = sqlStatement.getNames().stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedRuleNames, () -> new MissingRequiredRuleException("Sharding table reference", this.database.getName(), notExistedRuleNames));
    }

    private Collection<String> getCurrentShardingTableReferenceRuleNames() {
        return (Collection)this.rule.getConfiguration().getBindingTableGroups().stream().map(ShardingTableReferenceRuleConfiguration::getName).collect(Collectors.toCollection(CaseInsensitiveSet::new));
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(DropShardingTableReferenceRuleStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        for (String each : sqlStatement.getNames()) {
            result.getBindingTableGroups().add(new ShardingTableReferenceRuleConfiguration(each, ""));
        }
        return result;
    }

    public boolean hasAnyOneToBeDropped(DropShardingTableReferenceRuleStatement sqlStatement) {
        return !Collections.disjoint(this.getCurrentShardingTableReferenceRuleNames(), sqlStatement.getNames());
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<DropShardingTableReferenceRuleStatement> getType() {
        return DropShardingTableReferenceRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

