/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;

public final class UnusedAlgorithmFinder {
    public static Collection<String> findUnusedShardingAlgorithm(ShardingRuleConfiguration ruleConfig) {
        Collection inUsedAlgorithms = ruleConfig.getTables().stream().map(each -> Arrays.asList(each.getTableShardingStrategy(), each.getDatabaseShardingStrategy())).flatMap(Collection::stream).filter(Objects::nonNull).map(ShardingStrategyConfiguration::getShardingAlgorithmName).collect(Collectors.toSet());
        inUsedAlgorithms.addAll(ruleConfig.getTables().stream().filter(each -> null != each.getDatabaseShardingStrategy()).map(each -> each.getDatabaseShardingStrategy().getShardingAlgorithmName()).collect(Collectors.toSet()));
        inUsedAlgorithms.addAll(ruleConfig.getTables().stream().filter(each -> null != each.getTableShardingStrategy()).map(each -> each.getTableShardingStrategy().getShardingAlgorithmName()).collect(Collectors.toSet()));
        inUsedAlgorithms.addAll(ruleConfig.getAutoTables().stream().filter(each -> null != each.getShardingStrategy()).map(each -> each.getShardingStrategy().getShardingAlgorithmName()).collect(Collectors.toSet()));
        if (null != ruleConfig.getDefaultDatabaseShardingStrategy()) {
            inUsedAlgorithms.add(ruleConfig.getDefaultDatabaseShardingStrategy().getShardingAlgorithmName());
        }
        if (null != ruleConfig.getDefaultTableShardingStrategy()) {
            inUsedAlgorithms.add(ruleConfig.getDefaultTableShardingStrategy().getShardingAlgorithmName());
        }
        return ruleConfig.getShardingAlgorithms().keySet().stream().filter(each -> !inUsedAlgorithms.contains(each)).collect(Collectors.toSet());
    }

    public static Collection<String> findUnusedKeyGenerator(ShardingRuleConfiguration ruleConfig) {
        Collection inUsedKeyGenerators = ruleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getKeyGenerateStrategy).filter(Objects::nonNull).map(KeyGenerateStrategyConfiguration::getKeyGeneratorName).collect(Collectors.toSet());
        inUsedKeyGenerators.addAll(ruleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getKeyGenerateStrategy).filter(Objects::nonNull).map(KeyGenerateStrategyConfiguration::getKeyGeneratorName).collect(Collectors.toSet()));
        if (null != ruleConfig.getDefaultKeyGenerateStrategy()) {
            inUsedKeyGenerators.add(ruleConfig.getDefaultKeyGenerateStrategy().getKeyGeneratorName());
        }
        return ruleConfig.getKeyGenerators().keySet().stream().filter(each -> !inUsedKeyGenerators.contains(each)).collect(Collectors.toSet());
    }

    public static Collection<String> findUnusedAuditor(ShardingRuleConfiguration ruleConfig) {
        Collection inUsedAuditors = ruleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getAuditStrategy).filter(Objects::nonNull).flatMap(each -> each.getAuditorNames().stream()).collect(Collectors.toSet());
        inUsedAuditors.addAll(ruleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getAuditStrategy).filter(Objects::nonNull).flatMap(each -> each.getAuditorNames().stream()).collect(Collectors.toSet()));
        if (null != ruleConfig.getDefaultAuditStrategy()) {
            inUsedAuditors.addAll(ruleConfig.getDefaultAuditStrategy().getAuditorNames());
        }
        return ruleConfig.getAuditors().keySet().stream().filter(each -> !inUsedAuditors.contains(each)).collect(Collectors.toSet());
    }

    @Generated
    private UnusedAlgorithmFinder() {
    }
}

