/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shardingsphere.db.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.db.protocol.constant.CommonConstants;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.infra.exception.generic.UnknownSQLException;

public final class MySQLPacketCodecEngine
implements DatabasePacketCodecEngine {
    private static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private static final int PAYLOAD_LENGTH = 3;
    private static final int SEQUENCE_LENGTH = 1;
    private final List<ByteBuf> pendingMessages = new LinkedList<ByteBuf>();

    public boolean isValidHeader(int readableBytes) {
        return readableBytes >= 4;
    }

    public void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        int payloadLength = in.markReaderIndex().readUnsignedMediumLE();
        int remainPayloadLength = 1 + payloadLength;
        if (in.readableBytes() < remainPayloadLength) {
            in.resetReaderIndex();
            return;
        }
        ByteBuf message = in.readRetainedSlice(remainPayloadLength);
        if (0xFFFFFF == payloadLength) {
            this.pendingMessages.add(message.skipBytes(1));
        } else if (this.pendingMessages.isEmpty()) {
            out.add(message);
        } else {
            this.aggregateMessages(context, message, out);
        }
    }

    private void aggregateMessages(ChannelHandlerContext context, ByteBuf lastMessage, List<Object> out) {
        CompositeByteBuf result = context.alloc().compositeBuffer(1 + this.pendingMessages.size() + 1);
        result.addComponent(true, lastMessage.readSlice(1));
        Iterator<ByteBuf> pendingMessagesIterator = this.pendingMessages.iterator();
        result.addComponent(true, pendingMessagesIterator.next());
        while (pendingMessagesIterator.hasNext()) {
            result.addComponent(true, pendingMessagesIterator.next());
        }
        if (lastMessage.readableBytes() > 0) {
            result.addComponent(true, lastMessage);
        }
        out.add(result);
        this.pendingMessages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(ChannelHandlerContext context, DatabasePacket message, ByteBuf out) {
        MySQLPacketPayload payload = new MySQLPacketPayload(this.prepareMessageHeader(out).markWriterIndex(), (Charset)context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
        try {
            message.write((PacketPayload)payload);
        }
        catch (RuntimeException ex) {
            out.resetWriterIndex();
            new MySQLErrPacket(new UnknownSQLException((Exception)ex).toSQLException()).write((PacketPayload)payload);
        }
        finally {
            if (out.readableBytes() - 3 - 1 < 0xFFFFFF) {
                this.updateMessageHeader(out, ((AtomicInteger)context.channel().attr(MySQLConstants.SEQUENCE_ID_ATTRIBUTE_KEY).get()).getAndIncrement());
            } else {
                this.writeMultiPackets(context, out);
            }
        }
    }

    private ByteBuf prepareMessageHeader(ByteBuf out) {
        return out.writeInt(0);
    }

    private void updateMessageHeader(ByteBuf byteBuf, int sequenceId) {
        byteBuf.setMediumLE(0, byteBuf.readableBytes() - 3 - 1);
        byteBuf.setByte(3, sequenceId);
    }

    private void writeMultiPackets(ChannelHandlerContext context, ByteBuf byteBuf) {
        int packetCount = byteBuf.skipBytes(4).readableBytes() / 0xFFFFFF + 1;
        CompositeByteBuf result = context.alloc().compositeBuffer(packetCount * 2);
        AtomicInteger sequenceId = (AtomicInteger)context.channel().attr(MySQLConstants.SEQUENCE_ID_ATTRIBUTE_KEY).get();
        for (int i = 0; i < packetCount; ++i) {
            ByteBuf header = context.alloc().ioBuffer(4, 4);
            int packetLength = Math.min(byteBuf.readableBytes(), 0xFFFFFF);
            header.writeMediumLE(packetLength);
            header.writeByte(sequenceId.getAndIncrement());
            result.addComponent(true, header);
            if (packetLength <= 0) continue;
            result.addComponent(true, byteBuf.readRetainedSlice(packetLength));
        }
        context.write((Object)result);
    }

    public MySQLPacketPayload createPacketPayload(ByteBuf message, Charset charset) {
        return new MySQLPacketPayload(message, charset);
    }
}

