/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row;

import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.AbstractMySQLBinlogEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.MySQLBinlogEventHeader;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLNullBitmap;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLBinlogTableMapEventPacket
extends AbstractMySQLBinlogEventPacket {
    private final long tableId;
    private final int flags;
    private final String schemaName;
    private final String tableName;
    private final int columnCount;
    private final List<MySQLBinlogColumnDef> columnDefs;
    private final MySQLNullBitmap nullBitMap;

    public MySQLBinlogTableMapEventPacket(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        super(binlogEventHeader);
        this.tableId = payload.readInt6();
        this.flags = payload.readInt2();
        this.schemaName = payload.readStringFix(payload.readInt1());
        payload.skipReserved(1);
        this.tableName = payload.readStringFix(payload.readInt1());
        payload.skipReserved(1);
        this.columnCount = (int)payload.readIntLenenc();
        this.columnDefs = new LinkedList<MySQLBinlogColumnDef>();
        this.readColumnDefs(payload);
        this.readColumnMetaDefs(payload);
        this.nullBitMap = new MySQLNullBitmap(this.columnCount, payload);
        int remainBytesLength = this.getRemainBytesLength(payload);
        if (remainBytesLength > 0) {
            payload.skipReserved(remainBytesLength);
        }
    }

    private void readColumnDefs(MySQLPacketPayload payload) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.columnDefs.add(new MySQLBinlogColumnDef(MySQLBinaryColumnType.valueOf(payload.readInt1())));
        }
    }

    private void readColumnMetaDefs(MySQLPacketPayload payload) {
        payload.readIntLenenc();
        for (MySQLBinlogColumnDef each : this.columnDefs) {
            each.setColumnMeta(this.readColumnMetaDef(each.getColumnType(), payload));
        }
    }

    private int readColumnMetaDef(MySQLBinaryColumnType columnType, MySQLPacketPayload payload) {
        switch (columnType) {
            case STRING: 
            case DECIMAL: 
            case NEWDECIMAL: {
                return payload.getByteBuf().readUnsignedShort();
            }
            case BIT: 
            case VAR_STRING: 
            case VARCHAR: 
            case ENUM: {
                return payload.readInt2();
            }
            case BLOB: 
            case TINY_BLOB: 
            case DOUBLE: 
            case FLOAT: 
            case TIME2: 
            case TIMESTAMP2: 
            case DATETIME2: 
            case JSON: {
                return payload.readInt1();
            }
        }
        return 0;
    }

    @Override
    protected void writeEvent(MySQLPacketPayload payload) {
    }

    @Generated
    public long getTableId() {
        return this.tableId;
    }

    @Generated
    public int getFlags() {
        return this.flags;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public int getColumnCount() {
        return this.columnCount;
    }

    @Generated
    public List<MySQLBinlogColumnDef> getColumnDefs() {
        return this.columnDefs;
    }

    @Generated
    public MySQLNullBitmap getNullBitMap() {
        return this.nullBitMap;
    }
}

