/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.time;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.time.MySQLFractionalSeconds;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLDatetime2BinlogProtocolValue
implements MySQLBinlogProtocolValue {
    @Override
    public Serializable read(MySQLBinlogColumnDef columnDef, MySQLPacketPayload payload) {
        long datetime = this.readDatetimeV2FromPayload(payload);
        return 0L == datetime ? "0000-00-00 00:00:00" : this.readDatetime(columnDef, datetime, payload);
    }

    private long readDatetimeV2FromPayload(MySQLPacketPayload payload) {
        long result = 0L;
        for (int i = 4; i >= 0; --i) {
            result |= (long)payload.readInt1() << 8 * i;
        }
        return result;
    }

    private Serializable readDatetime(MySQLBinlogColumnDef columnDef, long datetime, MySQLPacketPayload payload) {
        long datetimeWithoutSign = datetime & 0x7FFFFFFFFFL;
        if (0L == datetimeWithoutSign) {
            return "0000-00-00 00:00:00";
        }
        long date = datetimeWithoutSign >> 17;
        long yearAndMonth = date >> 5;
        int year = (int)(yearAndMonth / 13L);
        int month = (int)(yearAndMonth % 13L);
        int day = (int)(date % 32L);
        long time = datetimeWithoutSign % 131072L;
        int hour = (int)(time >> 12);
        int minute = (int)((time >> 6) % 64L);
        int second = (int)(time % 64L);
        MySQLFractionalSeconds fractionalSeconds = new MySQLFractionalSeconds(columnDef.getColumnMeta(), payload);
        return Timestamp.valueOf(LocalDateTime.of(year, month, day, hour, minute, second, fractionalSeconds.getNanos()));
    }
}

