/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.query;

import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.db.protocol.packet.sql.SQLReceivedPacket;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;

public final class MySQLComQueryPacket
extends MySQLCommandPacket
implements SQLReceivedPacket {
    private final String sql;
    private final HintValueContext hintValueContext;

    public MySQLComQueryPacket(String sql) {
        super(MySQLCommandPacketType.COM_QUERY);
        this.hintValueContext = SQLHintUtils.extractHint((String)sql);
        this.sql = SQLHintUtils.removeHint((String)sql);
    }

    public MySQLComQueryPacket(MySQLPacketPayload payload) {
        super(MySQLCommandPacketType.COM_QUERY);
        String originSQL = payload.readStringEOF();
        this.hintValueContext = SQLHintUtils.extractHint((String)originSQL);
        this.sql = SQLHintUtils.removeHint((String)originSQL);
    }

    @Override
    public void doWrite(MySQLPacketPayload payload) {
        payload.writeStringEOF(this.sql);
    }

    public String getSQL() {
        return this.sql;
    }

    @Generated
    public HintValueContext getHintValueContext() {
        return this.hintValueContext;
    }
}

