/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.shardingsphere.shade.io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.resource.v1.internal.Resource;

public final class ResourceMarshaler
extends MarshalerWithSize {
    private static final WeakConcurrentMap<org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource, ResourceMarshaler> RESOURCE_MARSHALER_CACHE = new WeakConcurrentMap.WithInlinedExpunction<org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource, ResourceMarshaler>();
    private final byte[] serializedBinary;
    private final String serializedJson;

    public static ResourceMarshaler create(org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource resource) {
        ResourceMarshaler cached = (ResourceMarshaler)RESOURCE_MARSHALER_CACHE.get((Object)resource);
        if (cached == null) {
            RealResourceMarshaler realMarshaler = new RealResourceMarshaler(KeyValueMarshaler.createForAttributes(resource.getAttributes()));
            ByteArrayOutputStream binaryBos = new ByteArrayOutputStream(realMarshaler.getBinarySerializedSize());
            try {
                realMarshaler.writeBinaryTo(binaryBos);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Serialization error, this is likely a bug in OpenTelemetry.", e);
            }
            String json = MarshalerUtil.preserializeJsonFields(realMarshaler);
            cached = new ResourceMarshaler(binaryBos.toByteArray(), json);
            RESOURCE_MARSHALER_CACHE.put((Object)resource, (Object)cached);
        }
        return cached;
    }

    private ResourceMarshaler(byte[] binary, String json) {
        super(binary.length);
        this.serializedBinary = binary;
        this.serializedJson = json;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeSerializedMessage(this.serializedBinary, this.serializedJson);
    }

    private static final class RealResourceMarshaler
    extends MarshalerWithSize {
        private final KeyValueMarshaler[] attributes;

        private RealResourceMarshaler(KeyValueMarshaler[] attributes) {
            super(RealResourceMarshaler.calculateSize(attributes));
            this.attributes = attributes;
        }

        @Override
        protected void writeTo(Serializer output) throws IOException {
            output.serializeRepeatedMessage(Resource.ATTRIBUTES, this.attributes);
        }

        private static int calculateSize(KeyValueMarshaler[] attributeMarshalers) {
            return MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Resource.ATTRIBUTES, (Marshaler[])attributeMarshalers);
        }
    }
}

