/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.trace;

import io.grpc.ManagedChannel;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.shardingsphere.shade.io.opentelemetry.api.internal.Utils;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.compression.Compressor;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.compression.CompressorUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.trace.MarshalerTraceServiceGrpc;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.RetryPolicy;

public final class OtlpGrpcSpanExporterBuilder {
    static final String GRPC_SERVICE_NAME = "opentelemetry.proto.collector.trace.v1.TraceService";
    static final String GRPC_ENDPOINT_PATH = "/opentelemetry.proto.collector.trace.v1.TraceService/Export";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private static final MemoryMode DEFAULT_MEMORY_MODE = MemoryMode.IMMUTABLE_DATA;
    final GrpcExporterBuilder<Marshaler> delegate;
    private MemoryMode memoryMode;

    OtlpGrpcSpanExporterBuilder(GrpcExporterBuilder<Marshaler> delegate, MemoryMode memoryMode) {
        this.delegate = delegate;
        this.memoryMode = memoryMode;
        OtlpUserAgent.addUserAgentHeader(delegate::addConstantHeader);
    }

    OtlpGrpcSpanExporterBuilder() {
        this(new GrpcExporterBuilder<Marshaler>("otlp", "span", 10L, DEFAULT_ENDPOINT, () -> MarshalerTraceServiceGrpc::newFutureStub, GRPC_ENDPOINT_PATH), DEFAULT_MEMORY_MODE);
    }

    @Deprecated
    public OtlpGrpcSpanExporterBuilder setChannel(ManagedChannel channel) {
        this.delegate.setChannel(channel);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(timeout2, unit);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        this.delegate.setTimeout(timeout2);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setConnectTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.delegate.setConnectTimeout(timeout2, unit);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setConnectTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        return this.setConnectTimeout(timeout2.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpGrpcSpanExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Compressor compressor = CompressorUtil.validateAndResolveCompressor(compressionMethod);
        this.delegate.setCompression(compressor);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.delegate.setSslContext(sslContext, trustManager);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder addHeader(String key, String value) {
        this.delegate.addConstantHeader(key, value);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setHeaders(Supplier<Map<String, String>> headerSupplier) {
        this.delegate.setHeadersSupplier(headerSupplier);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.setMeterProvider(() -> meterProvider);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setMeterProvider(Supplier<MeterProvider> meterProviderSupplier) {
        Objects.requireNonNull(meterProviderSupplier, "meterProviderSupplier");
        this.delegate.setMeterProvider(meterProviderSupplier);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setMemoryMode(MemoryMode memoryMode) {
        Objects.requireNonNull(memoryMode, "memoryMode");
        this.memoryMode = memoryMode;
        return this;
    }

    public OtlpGrpcSpanExporter build() {
        return new OtlpGrpcSpanExporter(this.delegate, this.delegate.build(), this.memoryMode);
    }
}

