/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class LocalInetAddressSupplier
implements Supplier<InetAddress> {
    private static final Logger logger = Logger.getLogger(LocalInetAddressSupplier.class.getName());
    private static final LocalInetAddressSupplier INSTANCE = new LocalInetAddressSupplier(LocalInetAddressSupplier.findLocalIp());
    @Nullable
    private final InetAddress inetAddress;

    private LocalInetAddressSupplier(@Nullable InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    @Override
    @Nullable
    public InetAddress get() {
        return this.inetAddress;
    }

    @Nullable
    private static InetAddress findLocalIp() {
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface nic = nics.nextElement();
                Enumeration<InetAddress> addresses = nic.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!address.isSiteLocalAddress()) continue;
                    return address;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "error reading nics", e);
        }
        return null;
    }

    static LocalInetAddressSupplier getInstance() {
        return INSTANCE;
    }
}

