/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.Clock;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ScopeConfigurator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ScopeConfiguratorBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.InstrumentSelector;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.View;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.export.MetricProducer;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.export.MetricReader;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.MeterConfig;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.export.CardinalityLimitSelector;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource;

public final class SdkMeterProviderBuilder {
    private static final ExemplarFilter DEFAULT_EXEMPLAR_FILTER = ExemplarFilter.traceBased();
    private Clock clock = Clock.getDefault();
    private Resource resource = Resource.getDefault();
    private final IdentityHashMap<MetricReader, CardinalityLimitSelector> metricReaders = new IdentityHashMap();
    private final List<MetricProducer> metricProducers = new ArrayList<MetricProducer>();
    private final List<RegisteredView> registeredViews = new ArrayList<RegisteredView>();
    private ExemplarFilter exemplarFilter = DEFAULT_EXEMPLAR_FILTER;
    private ScopeConfiguratorBuilder<MeterConfig> meterConfiguratorBuilder = MeterConfig.configuratorBuilder();

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkMeterProviderBuilder addResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = this.resource.merge(resource);
        return this;
    }

    SdkMeterProviderBuilder setExemplarFilter(ExemplarFilter filter) {
        this.exemplarFilter = filter;
        return this;
    }

    public SdkMeterProviderBuilder registerView(InstrumentSelector selector, View view) {
        Objects.requireNonNull(selector, "selector");
        Objects.requireNonNull(view, "view");
        this.registeredViews.add(RegisteredView.create(selector, view, view.getAttributesProcessor(), view.getCardinalityLimit(), SourceInfo.fromCurrentStack()));
        return this;
    }

    public SdkMeterProviderBuilder registerMetricReader(MetricReader reader) {
        this.metricReaders.put(reader, CardinalityLimitSelector.defaultCardinalityLimitSelector());
        return this;
    }

    SdkMeterProviderBuilder registerMetricReader(MetricReader reader, CardinalityLimitSelector cardinalityLimitSelector) {
        this.metricReaders.put(reader, cardinalityLimitSelector);
        return this;
    }

    public SdkMeterProviderBuilder registerMetricProducer(MetricProducer metricProducer) {
        this.metricProducers.add(metricProducer);
        return this;
    }

    SdkMeterProviderBuilder setMeterConfigurator(ScopeConfigurator<MeterConfig> meterConfigurator) {
        this.meterConfiguratorBuilder = meterConfigurator.toBuilder();
        return this;
    }

    SdkMeterProviderBuilder addMeterConfiguratorCondition(Predicate<InstrumentationScopeInfo> scopeMatcher, MeterConfig meterConfig) {
        this.meterConfiguratorBuilder.addCondition(scopeMatcher, meterConfig);
        return this;
    }

    public SdkMeterProvider build() {
        return new SdkMeterProvider(this.registeredViews, this.metricReaders, this.metricProducers, this.clock, this.resource, this.exemplarFilter, this.meterConfiguratorBuilder.build());
    }
}

