/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.PrimitiveLongList;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.HistogramPointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramPointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.MutableHistogramPointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource;

public final class DoubleExplicitBucketHistogramAggregator
implements Aggregator<HistogramPointData, DoubleExemplarData> {
    private final double[] boundaries;
    private final MemoryMode memoryMode;
    private final List<Double> boundaryList;
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;

    public DoubleExplicitBucketHistogramAggregator(double[] boundaries, Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, MemoryMode memoryMode) {
        this.boundaries = boundaries;
        this.memoryMode = memoryMode;
        ArrayList<Double> boundaryList = new ArrayList<Double>(this.boundaries.length);
        for (double v : this.boundaries) {
            boundaryList.add(v);
        }
        this.boundaryList = Collections.unmodifiableList(boundaryList);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<HistogramPointData, DoubleExemplarData> createHandle() {
        return new Handle(this.boundaryList, this.boundaries, this.reservoirSupplier.get(), this.memoryMode);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Collection<HistogramPointData> pointData, AggregationTemporality temporality) {
        return ImmutableMetricData.createDoubleHistogram(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ImmutableHistogramData.create(temporality, pointData));
    }

    static final class Handle
    extends AggregatorHandle<HistogramPointData, DoubleExemplarData> {
        private final List<Double> boundaryList;
        private final double[] boundaries;
        private final Object lock = new Object();
        private double sum;
        private double min;
        private double max;
        private long count;
        private final long[] counts;
        @Nullable
        private MutableHistogramPointData reusablePoint;

        Handle(List<Double> boundaryList, double[] boundaries, ExemplarReservoir<DoubleExemplarData> reservoir, MemoryMode memoryMode) {
            super(reservoir);
            this.boundaryList = boundaryList;
            this.boundaries = boundaries;
            this.counts = new long[this.boundaries.length + 1];
            this.sum = 0.0;
            this.min = Double.MAX_VALUE;
            this.max = -1.0;
            this.count = 0L;
            if (memoryMode == MemoryMode.REUSABLE_DATA) {
                this.reusablePoint = new MutableHistogramPointData(this.counts.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HistogramPointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars, boolean reset) {
            Object object = this.lock;
            synchronized (object) {
                HistogramPointData pointData = this.reusablePoint == null ? ImmutableHistogramPointData.create(startEpochNanos, epochNanos, attributes, this.sum, this.count > 0L, this.min, this.count > 0L, this.max, this.boundaryList, PrimitiveLongList.wrap(Arrays.copyOf(this.counts, this.counts.length)), exemplars) : this.reusablePoint.set(startEpochNanos, epochNanos, attributes, this.sum, this.count > 0L, this.min, this.count > 0L, this.max, this.boundaryList, this.counts, exemplars);
                if (reset) {
                    this.sum = 0.0;
                    this.min = Double.MAX_VALUE;
                    this.max = -1.0;
                    this.count = 0L;
                    Arrays.fill(this.counts, 0L);
                }
                return pointData;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRecordDouble(double value) {
            int bucketIndex = ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, value);
            Object object = this.lock;
            synchronized (object) {
                this.sum += value;
                this.min = Math.min(this.min, value);
                this.max = Math.max(this.max, value);
                ++this.count;
                int n = bucketIndex;
                this.counts[n] = this.counts[n] + 1L;
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.doRecordDouble(value);
        }
    }
}

