/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.callback;

import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseConnector;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.callback.ProxyJDBCExecutorCallback;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.callback.impl.ProxyPreparedStatementExecutorCallback;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.callback.impl.ProxyStatementExecutorCallback;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class ProxyJDBCExecutorCallbackFactory {
    public static ProxyJDBCExecutorCallback newInstance(String type, DatabaseType protocolType, ResourceMetaData resourceMetaData, SQLStatement sqlStatement, DatabaseConnector databaseConnector, boolean isReturnGeneratedKeys, boolean isExceptionThrown, boolean isFetchMetaData) {
        if ("JDBC.STATEMENT".equals(type)) {
            return new ProxyStatementExecutorCallback(protocolType, resourceMetaData, sqlStatement, databaseConnector, isReturnGeneratedKeys, isExceptionThrown, isFetchMetaData);
        }
        if ("JDBC.PREPARED_STATEMENT".equals(type)) {
            return new ProxyPreparedStatementExecutorCallback(protocolType, resourceMetaData, sqlStatement, databaseConnector, isReturnGeneratedKeys, isExceptionThrown, isFetchMetaData);
        }
        throw new UnsupportedSQLOperationException(String.format("Unsupported driver type: `%s`", type));
    }

    @Generated
    private ProxyJDBCExecutorCallbackFactory() {
    }
}

