/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector.sane;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.proxy.backend.connector.sane.DialectSaneQueryResultEngine;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;

public final class SaneQueryResultEngine {
    private final DialectSaneQueryResultEngine dialectEngine;

    public SaneQueryResultEngine(DatabaseType databaseType) {
        this.dialectEngine = DatabaseTypedSPILoader.findService(DialectSaneQueryResultEngine.class, (DatabaseType)databaseType).orElse(null);
    }

    public Optional<ExecuteResult> getSaneQueryResult(SQLStatement sqlStatement, SQLException ex) {
        if (null == this.dialectEngine) {
            return sqlStatement instanceof SelectStatement ? Optional.of(this.getDefaultQueryResult()) : Optional.empty();
        }
        return this.dialectEngine.getSaneQueryResult(sqlStatement, ex);
    }

    private QueryResult getDefaultQueryResult() {
        RawQueryResultColumnMetaData queryResultColumnMetaData = new RawQueryResultColumnMetaData("", "", "", 12, "VARCHAR", 255, 0);
        MemoryQueryResultDataRow resultDataRow = new MemoryQueryResultDataRow(Collections.singletonList("1"));
        return new RawMemoryQueryResult((QueryResultMetaData)new RawQueryResultMetaData(Collections.singletonList(queryResultColumnMetaData)), Collections.singletonList(resultDataRow));
    }
}

