/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.DistSQLScriptConstants;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.distsql.statement.ral.queryable.convert.ConvertYamlConfigurationStatement;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.custom.CustomDataSourcePoolProperties;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.synonym.PoolPropertySynonyms;
import org.apache.shardingsphere.infra.exception.generic.FileIOException;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.yaml.YamlConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDataSourceConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.swapper.YamlProxyDataSourceConfigurationSwapper;

public final class ConvertYamlConfigurationExecutor
implements DistSQLQueryExecutor<ConvertYamlConfigurationStatement> {
    private final YamlProxyDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlProxyDataSourceConfigurationSwapper();

    public Collection<String> getColumnNames(ConvertYamlConfigurationStatement statement) {
        return Collections.singleton("dist_sql");
    }

    public Collection<LocalDataQueryResultRow> getRows(ConvertYamlConfigurationStatement sqlStatement, ContextManager contextManager) {
        YamlProxyDatabaseConfiguration yamlConfig;
        File file = new File(sqlStatement.getFilePath());
        try {
            yamlConfig = (YamlProxyDatabaseConfiguration)YamlEngine.unmarshal((File)file, YamlProxyDatabaseConfiguration.class);
        }
        catch (IOException ignore) {
            throw new FileIOException(file);
        }
        Preconditions.checkNotNull((Object)yamlConfig, (String)"Invalid yaml file `%s`", (Object)file.getName());
        Preconditions.checkNotNull((Object)yamlConfig.getDatabaseName(), (String)"`databaseName` in file `%s` is required.", (Object)file.getName());
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{this.convertYamlConfigToDistSQL(yamlConfig)}));
    }

    private String convertYamlConfigToDistSQL(YamlProxyDatabaseConfiguration yamlConfig) {
        StringBuilder result = new StringBuilder();
        result.append(this.convertDatabase(yamlConfig.getDatabaseName()));
        result.append(System.lineSeparator()).append(System.lineSeparator());
        if (null == yamlConfig.getDataSources() || yamlConfig.getDataSources().isEmpty()) {
            return result.toString();
        }
        result.append(this.convertDataSources(yamlConfig.getDataSources()));
        result.append(System.lineSeparator()).append(System.lineSeparator());
        if (null == yamlConfig.getRules() || yamlConfig.getRules().isEmpty()) {
            return result.toString();
        }
        for (RuleConfiguration each : this.swapToRuleConfigs(yamlConfig).values()) {
            result.append(((RuleConfigurationToDistSQLConverter)TypedSPILoader.getService(RuleConfigurationToDistSQLConverter.class, each.getClass())).convert(each));
            result.append(System.lineSeparator()).append(System.lineSeparator());
        }
        return result.toString();
    }

    private String convertDatabase(String databaseName) {
        return String.format("CREATE DATABASE %s;", databaseName) + System.lineSeparator() + String.format("USE %s;", databaseName);
    }

    private String convertDataSources(Map<String, YamlProxyDataSourceConfiguration> dataSources) {
        StringBuilder result = new StringBuilder("REGISTER STORAGE UNIT");
        Iterator<Map.Entry<String, YamlProxyDataSourceConfiguration>> iterator = dataSources.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, YamlProxyDataSourceConfiguration> entry = iterator.next();
            DataSourceConfiguration dataSourceConfig = this.dataSourceConfigSwapper.swap(entry.getValue());
            DataSourcePoolProperties props = DataSourcePoolPropertiesCreator.create((DataSourceConfiguration)dataSourceConfig);
            result.append(this.convertDataSource(entry.getKey(), props));
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        result.append(";");
        return result.toString();
    }

    private String convertDataSource(String resourceName, DataSourcePoolProperties dataSourcePoolProps) {
        Map connectionProps = dataSourcePoolProps.getConnectionPropertySynonyms().getStandardProperties();
        String url = (String)connectionProps.get("url");
        String username = (String)connectionProps.get("username");
        String password = (String)connectionProps.get("password");
        String props = this.getDataSourcePoolProps(dataSourcePoolProps.getPoolPropertySynonyms(), dataSourcePoolProps.getCustomProperties());
        if (Strings.isNullOrEmpty((String)password)) {
            return String.format(DistSQLScriptConstants.STORAGE_UNIT_DEFINITION_WITHOUT_PASSWORD, resourceName, url, username, props);
        }
        return String.format(DistSQLScriptConstants.STORAGE_UNIT_DEFINITION, resourceName, url, username, password, props);
    }

    private String getDataSourcePoolProps(PoolPropertySynonyms poolPropertySynonyms, CustomDataSourcePoolProperties customDataSourcePoolProps) {
        StringBuilder result = new StringBuilder();
        result.append(this.getDataSourcePoolProps(poolPropertySynonyms.getStandardProperties()));
        if (!customDataSourcePoolProps.getProperties().isEmpty()) {
            result.append(",");
            result.append(this.getDataSourcePoolProps(customDataSourcePoolProps.getProperties()));
        }
        return result.toString();
    }

    private String getDataSourcePoolProps(Map<String, Object> props) {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (null == entry.getValue()) continue;
            result.append(String.format("'%s'='%s'", entry.getKey(), entry.getValue()));
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    private Map<Integer, RuleConfiguration> swapToRuleConfigs(YamlProxyDatabaseConfiguration yamlConfig) {
        TreeMap<Integer, RuleConfiguration> result = new TreeMap<Integer, RuleConfiguration>(Comparator.reverseOrder());
        for (YamlRuleConfiguration each : yamlConfig.getRules()) {
            YamlRuleConfigurationSwapper swapper = (YamlRuleConfigurationSwapper)OrderedSPILoader.getServicesByClass(YamlRuleConfigurationSwapper.class, Collections.singleton(each.getRuleConfigurationType())).get(each.getRuleConfigurationType());
            result.put(swapper.getOrder(), (RuleConfiguration)swapper.swapToObject((YamlConfiguration)each));
        }
        return result;
    }

    public Class<ConvertYamlConfigurationStatement> getType() {
        return ConvertYamlConfigurationStatement.class;
    }
}

