/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.response.header.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class UpdateResponseHeader
implements ResponseHeader {
    private final SQLStatement sqlStatement;
    private final long lastInsertId;
    private final Collection<Integer> updateCounts = new LinkedList<Integer>();
    private long updateCount;

    public UpdateResponseHeader(SQLStatement sqlStatement) {
        this(sqlStatement, Collections.emptyList(), Collections.emptyList());
    }

    public UpdateResponseHeader(SQLStatement sqlStatement, Collection<UpdateResult> updateResults) {
        this(sqlStatement, updateResults, Collections.emptyList());
    }

    public UpdateResponseHeader(SQLStatement sqlStatement, Collection<UpdateResult> updateResults, Collection<Comparable<?>> autoIncrementGeneratedValues) {
        this.sqlStatement = sqlStatement;
        this.lastInsertId = this.getLastInsertId(updateResults, autoIncrementGeneratedValues);
        this.updateCount = updateResults.iterator().hasNext() ? (long)updateResults.iterator().next().getUpdateCount() : 0L;
        for (UpdateResult each : updateResults) {
            this.updateCounts.add(each.getUpdateCount());
        }
    }

    private long getLastInsertId(Collection<UpdateResult> updateResults, Collection<Comparable<?>> autoIncrementGeneratedValues) {
        ArrayList<Long> lastInsertIds = new ArrayList<Long>(updateResults.size() + autoIncrementGeneratedValues.size());
        for (UpdateResult updateResult : updateResults) {
            if (updateResult.getLastInsertId() <= 0L) continue;
            lastInsertIds.add(updateResult.getLastInsertId());
        }
        for (Comparable comparable : autoIncrementGeneratedValues) {
            if (!(comparable instanceof Number)) continue;
            lastInsertIds.add(((Number)((Object)comparable)).longValue());
        }
        return lastInsertIds.isEmpty() ? 0L : this.getMinLastInsertId(lastInsertIds);
    }

    private long getMinLastInsertId(List<Long> lastInsertIds) {
        Collections.sort(lastInsertIds);
        return lastInsertIds.iterator().next();
    }

    public void mergeUpdateCount() {
        this.updateCount = 0L;
        for (int each : this.updateCounts) {
            this.updateCount += (long)each;
        }
    }

    @Generated
    public SQLStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public long getLastInsertId() {
        return this.lastInsertId;
    }

    @Generated
    public long getUpdateCount() {
        return this.updateCount;
    }
}

