/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.state.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.distsql.statement.ral.updatable.UnlockClusterStatement;
import org.apache.shardingsphere.distsql.statement.ral.updatable.UpdatableRALStatement;
import org.apache.shardingsphere.distsql.statement.rdl.RDLStatement;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.mode.exception.ClusterStateException;
import org.apache.shardingsphere.proxy.backend.state.ProxyClusterState;
import org.apache.shardingsphere.proxy.backend.state.SQLSupportedJudgeEngine;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;

public final class ReadOnlyProxyState
implements ProxyClusterState {
    private static final Collection<Class<? extends SQLStatement>> SUPPORTED_SQL_STATEMENTS = Collections.singleton(UnlockClusterStatement.class);
    private static final Collection<Class<? extends SQLStatement>> UNSUPPORTED_SQL_STATEMENTS = Arrays.asList(InsertStatement.class, UpdateStatement.class, DeleteStatement.class, DDLStatement.class, UpdatableRALStatement.class, RDLStatement.class);
    private final SQLSupportedJudgeEngine judgeEngine = new SQLSupportedJudgeEngine(SUPPORTED_SQL_STATEMENTS, UNSUPPORTED_SQL_STATEMENTS);

    @Override
    public void check(SQLStatement sqlStatement) {
        ShardingSpherePreconditions.checkState((boolean)this.judgeEngine.isSupported(sqlStatement), () -> new ClusterStateException(this.getType(), sqlStatement));
    }

    public String getType() {
        return "READ_ONLY";
    }
}

